/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.DbsnpArgumentCollection;
import org.broadinstitute.hellbender.cmdline.programgroups.ShortVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.MultiVariantWalkerGroupedOnStart;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.ReferenceConfidenceVariantContextMerger;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.genotyper.IndexedSampleList;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

@CommandLineProgramProperties(summary="Merges one or more HaplotypeCaller GVCF files into a single GVCF with appropriate annotations", oneLineSummary="Merges one or more HaplotypeCaller GVCF files into a single GVCF with appropriate annotations", programGroup=ShortVariantDiscoveryProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public final class CombineGVCFs
extends MultiVariantWalkerGroupedOnStart {
    private VariantAnnotatorEngine annotationEngine;
    private VariantContextWriter vcfWriter;
    private SAMSequenceDictionary sequenceDictionary;
    private ReferenceConfidenceVariantContextMerger referenceConfidenceVariantContextMerger;
    public static final String BP_RES_LONG_NAME = "convert-to-base-pair-resolution";
    public static final String BREAK_BANDS_LONG_NAME = "break-bands-at-multiples-of";
    public static final String SOMATIC_INPUT_LONG_NAME = "input-is-somatic";
    public static final String DROP_SOMATIC_FILTERING_ANNOTATIONS_LONG_NAME = "drop-somatic-filtering-annotations";
    public static final String ALLELE_FRACTION_DELTA_LONG_NAME = "allele-fraction-error";
    @Argument(fullName="output", shortName="O", doc="The combined GVCF output file", optional=false)
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    private GATKPath outputFile;
    @Argument(fullName="convert-to-base-pair-resolution", doc="If specified, convert banded gVCFs to all-sites gVCFs", optional=true)
    protected boolean useBpResolution = false;
    @Argument(fullName="break-bands-at-multiples-of", doc="If > 0, reference bands will be broken up at genomic positions that are multiples of this number", optional=true)
    protected int multipleAtWhichToBreakBands = 0;
    @Argument(fullName="input-is-somatic", doc="Merge input GVCFs according to somatic (i.e. Mutect2) annotations (BETA)")
    protected boolean somaticInput = false;
    @Argument(fullName="drop-somatic-filtering-annotations", doc="For input somatic GVCFs (i.e. from Mutect2) drop filtering annotations")
    protected boolean dropSomaticFilteringAnnotations = false;
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    private final LinkedList<VariantContext> variantContextsOverlappingCurrentMerge = new LinkedList();
    private final Set<String> samples = new HashSet<String>();
    private SimpleInterval prevPos = null;
    private byte refAfterPrevPos;
    private ReferenceContext storedReferenceContext;

    @Override
    public boolean useVariantAnnotations() {
        return true;
    }

    @Override
    public List<Class<? extends Annotation>> getDefaultVariantAnnotationGroups() {
        return Collections.singletonList(StandardAnnotation.class);
    }

    @Override
    public void apply(List<VariantContext> variantContexts, ReferenceContext referenceContext, List<ReadsContext> readsContexts) {
        for (VariantContext ctx : variantContexts) {
            if (!GATKVariantContextUtils.isUnmixedMnpIgnoringNonRef(ctx)) continue;
            throw new UserException.BadInput(String.format("Combining gVCFs containing MNPs is not supported. %1s contained a MNP at %2s:%3d", ctx.getSource(), ctx.getContig(), ctx.getStart()));
        }
        if (!this.variantContextsOverlappingCurrentMerge.isEmpty()) {
            Locatable last = this.prevPos != null && this.prevPos.getContig().equals(this.variantContextsOverlappingCurrentMerge.get(0).getContig()) ? this.prevPos : (Locatable)this.variantContextsOverlappingCurrentMerge.get(0);
            int end = last.getContig().equals(referenceContext.getWindow().getContig()) ? referenceContext.getInterval().getStart() - 1 : this.variantContextsOverlappingCurrentMerge.stream().mapToInt(VariantContext::getEnd).max().getAsInt();
            this.createIntermediateVariants(new SimpleInterval(last.getContig(), last.getStart(), end));
        }
        this.mergeWithNewVCs(variantContexts, referenceContext);
        if (this.storedReferenceContext == null || !referenceContext.getWindow().contigsMatch(this.storedReferenceContext.getWindow()) || this.storedReferenceContext.getWindow().getEnd() < referenceContext.getWindow().getEnd()) {
            this.storedReferenceContext = referenceContext;
        }
    }

    @VisibleForTesting
    void createIntermediateVariants(SimpleInterval intervalToClose) {
        this.resizeReferenceIfNeeded(intervalToClose);
        Set<Integer> sitesToStop = CombineGVCFs.getIntermediateStopSites(intervalToClose, this.multipleAtWhichToBreakBands);
        for (VariantContext vc : this.variantContextsOverlappingCurrentMerge) {
            if (vc.getNAlleles() > 2) {
                for (int i = vc.getStart(); i <= vc.getEnd(); ++i) {
                    sitesToStop.add(i);
                }
                continue;
            }
            if (vc.getEnd() > intervalToClose.getEnd()) continue;
            sitesToStop.add(vc.getEnd());
        }
        ArrayList<Integer> stoppedLocs = new ArrayList<Integer>(sitesToStop);
        stoppedLocs.sort(Comparator.naturalOrder());
        Iterator iterator = stoppedLocs.iterator();
        while (iterator.hasNext()) {
            int stoppedLoc = (Integer)iterator.next();
            SimpleInterval loc = new SimpleInterval(intervalToClose.getContig(), stoppedLoc, stoppedLoc);
            if (stoppedLoc > intervalToClose.getEnd() || stoppedLoc < intervalToClose.getStart() || !this.isWithinInterval(loc)) continue;
            byte[] refBases = Arrays.copyOfRange(this.storedReferenceContext.getBases(), stoppedLoc - this.storedReferenceContext.getWindow().getStart(), stoppedLoc - this.storedReferenceContext.getWindow().getStart() + 2);
            this.endPreviousStates(loc, refBases, Collections.emptyList(), true);
        }
    }

    @VisibleForTesting
    protected static final Set<Integer> getIntermediateStopSites(SimpleInterval intervalToClose, int breakBandMultiple) {
        HashSet<Integer> sitesToStop = new HashSet<Integer>();
        if (breakBandMultiple > 0) {
            int blockEndPosition;
            int n = blockEndPosition = intervalToClose.getStart() < breakBandMultiple + 1 ? Math.max(2, breakBandMultiple) : intervalToClose.getStart() / breakBandMultiple * breakBandMultiple;
            while (blockEndPosition <= intervalToClose.getEnd()) {
                sitesToStop.add(blockEndPosition - 1);
                blockEndPosition += breakBandMultiple;
            }
        }
        return sitesToStop;
    }

    private void resizeReferenceIfNeeded(SimpleInterval intervalToClose) {
        int leftEdge = this.storedReferenceContext.getInterval().getStart() - intervalToClose.getStart();
        int rightEdge = intervalToClose.getEnd() - this.storedReferenceContext.getInterval().getEnd();
        this.storedReferenceContext.setWindow(Math.max(1, leftEdge), Math.max(1, rightEdge));
    }

    @Override
    public void onTraversalStart() {
        if (this.somaticInput) {
            this.logger.warn("Note that the Mutect2 reference confidence mode is in BETA -- the likelihoods model and output format are subject to change in subsequent versions.");
        }
        this.annotationEngine = new VariantAnnotatorEngine(this.makeVariantAnnotations(), this.dbsnp.dbsnp, Collections.emptyList(), false, false);
        this.vcfWriter = this.getVCFWriter();
        this.referenceConfidenceVariantContextMerger = new ReferenceConfidenceVariantContextMerger(this.annotationEngine, this.getHeaderForVariants(), this.somaticInput, this.dropSomaticFilteringAnnotations);
        this.sequenceDictionary = this.getBestAvailableSequenceDictionary();
        if (this.multipleAtWhichToBreakBands == 1 || this.useBpResolution) {
            this.useBpResolution = true;
            this.multipleAtWhichToBreakBands = 1;
        }
    }

    private VariantContextWriter getVCFWriter() {
        SortedSet<String> samples = this.getSamplesForVariants();
        VCFHeader inputVCFHeader = new VCFHeader(this.getHeaderForVariants().getMetaDataInInputOrder(), samples);
        LinkedHashSet<Object> headerLines = new LinkedHashSet<Object>(inputVCFHeader.getMetaDataInInputOrder());
        headerLines.addAll(this.getDefaultToolVCFHeaderLines());
        headerLines.addAll(this.annotationEngine.getVCFAnnotationDescriptions());
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"DP"));
        if (this.dbsnp.dbsnp != null) {
            VCFStandardHeaderLines.addStandardInfoLines(headerLines, (boolean)true, (String[])new String[]{"DB"});
        }
        if (this.somaticInput) {
            headerLines.add(VCFStandardHeaderLines.getFormatLine((String)"FT"));
            if (!this.dropSomaticFilteringAnnotations) {
                for (String key : Mutect2FilteringEngine.STANDARD_MUTECT_INFO_FIELDS_FOR_FILTERING) {
                    headerLines.add(GATKVCFHeaderLines.getEquivalentFormatHeaderLine(key));
                }
            }
        }
        VariantContextWriter writer = this.createVCFWriter(this.outputFile);
        Set<String> sampleNameSet = new IndexedSampleList(samples).asSetOfSamples();
        VCFHeader vcfHeader = new VCFHeader(headerLines, new TreeSet<String>(sampleNameSet));
        writer.writeHeader(vcfHeader);
        return writer;
    }

    public void mergeWithNewVCs(List<VariantContext> variantContexts, ReferenceContext referenceContext) {
        if (!variantContexts.isEmpty()) {
            SimpleInterval loc;
            if (!this.okayToSkipThisSite(variantContexts, referenceContext) && (loc = referenceContext.getInterval()).getStart() - 1 > 0) {
                this.endPreviousStates(new SimpleInterval(loc.getContig(), loc.getStart() - 1, loc.getStart() - 1), Arrays.copyOfRange(referenceContext.getBases(), 1, referenceContext.getWindow().getLengthOnReference()), variantContexts, false);
            }
            this.variantContextsOverlappingCurrentMerge.addAll(variantContexts);
            for (VariantContext vc : this.variantContextsOverlappingCurrentMerge) {
                this.samples.addAll(vc.getSampleNames());
            }
        }
    }

    private boolean okayToSkipThisSite(List<VariantContext> variantContexts, ReferenceContext referenceContext) {
        HashSet<String> intersection = new HashSet<String>(this.getSamples(variantContexts));
        intersection.retainAll(this.samples);
        return this.prevPos != null && referenceContext.getInterval().getStart() == this.prevPos.getStart() + 1 && intersection.isEmpty();
    }

    private Set<String> getSamples(List<VariantContext> variantContexts) {
        HashSet<String> output = new HashSet<String>();
        for (VariantContext vc : variantContexts) {
            output.addAll(vc.getSampleNames());
        }
        return output;
    }

    private void endPreviousStates(SimpleInterval pos, byte[] refBases, List<VariantContext> variantContexts, boolean forceOutputAtCurrentPosition) {
        Set<String> newSamples = this.getSamples(variantContexts);
        byte refBase = refBases[0];
        byte refNextBase = forceOutputAtCurrentPosition ? (refBases.length > 1 ? refBases[1] : (byte)78) : refBase;
        ArrayList<VariantContext> stoppedVCs = new ArrayList<VariantContext>(this.variantContextsOverlappingCurrentMerge.size());
        for (int i = this.variantContextsOverlappingCurrentMerge.size() - 1; i >= 0; --i) {
            VariantContext vc = this.variantContextsOverlappingCurrentMerge.get(i);
            if (vc.getStart() > pos.getStart() && vc.contigsMatch((Locatable)pos)) continue;
            stoppedVCs.add(vc);
            if (vc.getEnd() != pos.getStart() && (variantContexts.size() <= 0 || forceOutputAtCurrentPosition || !newSamples.containsAll(vc.getSampleNames()))) continue;
            this.samples.removeAll(vc.getSampleNames());
            this.variantContextsOverlappingCurrentMerge.remove(i);
        }
        if (!stoppedVCs.isEmpty() && (this.prevPos == null || IntervalUtils.isAfter(pos, this.prevPos, this.sequenceDictionary))) {
            SimpleInterval closingSpot = new SimpleInterval(((VariantContext)stoppedVCs.get(0)).getContig(), pos.getStart(), pos.getStart());
            VariantContext mergedVC = CombineGVCFs.containsTrueAltAllele(stoppedVCs) ? this.referenceConfidenceVariantContextMerger.merge(stoppedVCs, closingSpot, refBase, false, false) : this.referenceBlockMerge(stoppedVCs, pos.getStart());
            this.vcfWriter.add(mergedVC);
            this.prevPos = closingSpot;
            this.refAfterPrevPos = refNextBase;
        }
    }

    private VariantContext referenceBlockMerge(List<VariantContext> vcs, int end) {
        Allele refAllele;
        int start;
        VariantContext first = vcs.get(0);
        if (this.prevPos == null || !this.prevPos.getContig().equals(first.getContig()) || first.getStart() >= this.prevPos.getStart() + 1) {
            start = first.getStart();
            refAllele = first.getReference();
        } else {
            start = this.prevPos.getStart() + 1;
            refAllele = Allele.create((byte)this.refAfterPrevPos, (boolean)true);
        }
        HashMap<String, String> attrs = new HashMap<String, String>(1);
        if (!this.useBpResolution && end != start) {
            attrs.put("END", Integer.toString(end));
        }
        GenotypesContext genotypes = GenotypesContext.create();
        for (VariantContext vc : vcs) {
            for (Genotype g : vc.getGenotypes()) {
                genotypes.add(new GenotypeBuilder(g).alleles(GATKVariantContextUtils.noCallAlleles(g.getPloidy())).make());
            }
        }
        return new VariantContextBuilder("", first.getContig(), (long)start, (long)end, Arrays.asList(refAllele, Allele.NON_REF_ALLELE)).attributes(attrs).genotypes(genotypes).make();
    }

    private static boolean containsTrueAltAllele(List<VariantContext> VCs) {
        for (VariantContext vc : VCs) {
            if (vc.getNAlleles() <= 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object onTraversalSuccess() {
        if (this.storedReferenceContext == null) {
            this.logger.warn("Error: The requested interval contained no data in source VCF files");
            return null;
        }
        if (!this.variantContextsOverlappingCurrentMerge.isEmpty()) {
            SimpleInterval lastInterval = new SimpleInterval(this.variantContextsOverlappingCurrentMerge.get(0).getContig(), this.variantContextsOverlappingCurrentMerge.get(0).getStart(), this.variantContextsOverlappingCurrentMerge.stream().map(VariantContext::getEnd).max(Comparator.naturalOrder()).get());
            this.createIntermediateVariants(lastInterval);
            if (!this.variantContextsOverlappingCurrentMerge.isEmpty()) {
                this.logger.warn("You have asked for an interval that cuts in the middle of one or more gVCF blocks. Please note that this will cause you to lose records that don't end within your interval.");
            }
        }
        return null;
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }
}

