/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers;

import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.OptionalTextOutputArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;

@DocumentedFeature
@CommandLineProgramProperties(summary="This tool counts the variant records in a VCF file, regardless of filter status. Because it counts the number of rows in the VCF, it does not necessarily reflect the number of variant alleles. The count is printed to standard output (and may optionally be written to a file)", oneLineSummary="Counts variant records in a VCF file, regardless of filter status.", programGroup=VariantEvaluationProgramGroup.class)
public final class CountVariants
extends VariantWalker {
    private long count = 0L;
    static final String USAGE_ONE_LINE_SUMMARY = "Counts variant records in a VCF file, regardless of filter status.";
    static final String USAGE_SUMMARY = "This tool counts the variant records in a VCF file, regardless of filter status. Because it counts the number of rows in the VCF, it does not necessarily reflect the number of variant alleles. The count is printed to standard output (and may optionally be written to a file)";
    @ArgumentCollection
    public final OptionalTextOutputArgumentCollection out = new OptionalTextOutputArgumentCollection();

    @Override
    public void apply(VariantContext variant, ReadsContext readsContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        ++this.count;
    }

    @Override
    public Object onTraversalSuccess() {
        this.out.print(this.count);
        return this.count;
    }
}

