/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.DbsnpArgumentCollection;
import org.broadinstitute.hellbender.cmdline.programgroups.ShortVariantDiscoveryProgramGroup;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantLocusWalker;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBArgumentCollection;
import org.broadinstitute.hellbender.tools.genomicsdb.GenomicsDBOptions;
import org.broadinstitute.hellbender.tools.walkers.GenotypeGVCFsEngine;
import org.broadinstitute.hellbender.tools.walkers.ReferenceConfidenceVariantContextMerger;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeCalculationArgumentCollection;
import org.broadinstitute.hellbender.utils.GenomeLoc;
import org.broadinstitute.hellbender.utils.GenomeLocParser;
import org.broadinstitute.hellbender.utils.GenomeLocSortedSet;
import org.broadinstitute.hellbender.utils.IntervalMergingRule;
import org.broadinstitute.hellbender.utils.IntervalSetRule;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

@CommandLineProgramProperties(summary="Perform joint genotyping on a single-sample GVCF from HaplotypeCaller or a multi-sample GVCF from CombineGVCFs or GenomicsDBImport", oneLineSummary="Perform joint genotyping on one or more samples pre-called with HaplotypeCaller", programGroup=ShortVariantDiscoveryProgramGroup.class)
@DocumentedFeature
public final class GenotypeGVCFs
extends VariantLocusWalker {
    public static final String PHASED_HOM_VAR_STRING = "1|1";
    public static final String ONLY_OUTPUT_CALLS_STARTING_IN_INTERVALS_FULL_NAME = "only-output-calls-starting-in-intervals";
    public static final String ALL_SITES_LONG_NAME = "include-non-variant-sites";
    public static final String ALL_SITES_SHORT_NAME = "all-sites";
    public static final String KEEP_COMBINED_LONG_NAME = "keep-combined-raw-annotations";
    public static final String KEEP_COMBINED_SHORT_NAME = "keep-combined";
    public static final String FORCE_OUTPUT_INTERVALS_NAME = "force-output-intervals";
    @Argument(fullName="output", shortName="O", doc="File to which variants should be written", optional=false)
    private GATKPath outputFile;
    @Argument(fullName="include-non-variant-sites", shortName="all-sites", doc="Include loci found to be non-variant after genotyping", optional=true)
    private boolean includeNonVariants = false;
    @Argument(fullName="merge-input-intervals", shortName="merge-input-intervals", doc="Boolean flag to import all data in between intervals.")
    private boolean mergeInputIntervals = false;
    @Argument(fullName="input-is-somatic", doc="Finalize input GVCF according to somatic (i.e. Mutect2) TLODs (BETA feature)")
    protected boolean somaticInput = false;
    @Argument(fullName="tumor-lod-to-emit", shortName="emit-lod", doc="LOD threshold to emit variant to VCF.")
    protected double tlodThreshold = 3.5;
    @Argument(fullName="allele-fraction-error", doc="Margin of error in allele fraction to consider a somatic variant homoplasmic")
    protected double afTolerance = 0.001;
    @Argument(fullName="keep-combined-raw-annotations", shortName="keep-combined", doc="If specified, keep the combined raw annotations")
    protected boolean keepCombined = false;
    @ArgumentCollection
    private GenotypeCalculationArgumentCollection genotypeArgs = new GenotypeCalculationArgumentCollection();
    @ArgumentCollection
    private GenomicsDBArgumentCollection genomicsdbArgs = new GenomicsDBArgumentCollection();
    @Advanced
    @Argument(fullName="only-output-calls-starting-in-intervals", doc="Restrict variant output to sites that start within provided intervals", optional=true)
    private boolean onlyOutputCallsStartingInIntervals = false;
    @Argument(fullName="force-output-intervals", suppressFileExpansion=true, doc="sites at which to output genotypes even if non-variant in samples", optional=true)
    protected final List<String> forceOutputIntervalStrings = new ArrayList<String>();
    @ArgumentCollection
    private final DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    private VariantAnnotatorEngine annotationEngine;
    private ReferenceConfidenceVariantContextMerger merger;
    private VariantContextWriter vcfWriter;
    private List<SimpleInterval> intervals;
    private OverlapDetector<GenomeLoc> forceOutputIntervals;
    private boolean forceOutputIntervalsPresent;
    private GenotypeGVCFsEngine gvcfEngine;

    @Override
    protected List<SimpleInterval> transformTraversalIntervals(List<SimpleInterval> getIntervals, SAMSequenceDictionary sequenceDictionary) {
        if (this.mergeInputIntervals) {
            return IntervalUtils.getSpanningIntervals(getIntervals, sequenceDictionary);
        }
        return getIntervals;
    }

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    protected GenomicsDBOptions getGenomicsDBOptions() {
        if (this.genomicsDBOptions == null) {
            this.genomicsDBOptions = new GenomicsDBOptions(this.referenceArguments.getReferencePath(), this.genomicsdbArgs, this.genotypeArgs);
        }
        return this.genomicsDBOptions;
    }

    @Override
    public boolean useVariantAnnotations() {
        return true;
    }

    @Override
    public List<Class<? extends Annotation>> getDefaultVariantAnnotationGroups() {
        return Arrays.asList(StandardAnnotation.class);
    }

    @Override
    public void onTraversalStart() {
        if (this.somaticInput) {
            this.logger.warn("Note that the Mutect2 reference confidence mode is in BETA -- the likelihoods model and output format are subject to change in subsequent versions.");
        }
        boolean bl = this.forceOutputIntervalsPresent = !this.forceOutputIntervalStrings.isEmpty();
        if (this.includeNonVariants && this.forceOutputIntervalsPresent) {
            throw new CommandLineException.BadArgumentValue(String.format("Force output (--%s) is incompatible with including non-variants (--%s and --%s).  Use the latter to force genotyping at all sites and the former to force genotyping only at given sites.In both cases, variant sites are genotyped as usual.", FORCE_OUTPUT_INTERVALS_NAME, ALL_SITES_LONG_NAME, ALL_SITES_SHORT_NAME));
        }
        GenomeLocSortedSet forceOutputLocs = IntervalUtils.loadIntervals(this.forceOutputIntervalStrings, IntervalSetRule.UNION, IntervalMergingRule.ALL, 0, new GenomeLocParser(this.getSequenceDictionaryForDrivingVariants()));
        this.forceOutputIntervals = OverlapDetector.create(forceOutputLocs.toList());
        if (!this.includeNonVariants && !this.forceOutputIntervalsPresent) {
            this.changeTraversalModeToByVariant();
        }
        VCFHeader inputVCFHeader = this.getHeaderForVariants();
        if (this.onlyOutputCallsStartingInIntervals && !this.hasUserSuppliedIntervals()) {
            throw new CommandLineException.MissingArgument("-L or -XL", "Intervals are required if --only-output-calls-starting-in-intervals was specified.");
        }
        this.intervals = this.hasUserSuppliedIntervals() ? this.intervalArgumentCollection.getIntervals(this.getBestAvailableSequenceDictionary()) : Collections.emptyList();
        this.annotationEngine = new VariantAnnotatorEngine(this.makeVariantAnnotations(), this.dbsnp.dbsnp, Collections.emptyList(), false, this.keepCombined);
        this.merger = new ReferenceConfidenceVariantContextMerger(this.annotationEngine, this.getHeaderForVariants(), this.somaticInput);
        Set<VCFHeaderLine> defaultToolVCFHeaderLines = this.getDefaultToolVCFHeaderLines();
        this.vcfWriter = this.createVCFWriter(this.outputFile);
        this.gvcfEngine = new GenotypeGVCFsEngine(this.annotationEngine, this.genotypeArgs, this.includeNonVariants, inputVCFHeader);
        this.vcfWriter = this.gvcfEngine.setupVCFWriter(defaultToolVCFHeaderLines, this.keepCombined, this.dbsnp, this.vcfWriter);
    }

    @Override
    public void apply(Locatable loc, List<VariantContext> variants, ReadsContext reads, ReferenceContext ref, FeatureContext features) {
        boolean inForceOutputIntervals = this.forceOutputIntervalsPresent && this.forceOutputIntervals.overlapsAny(loc);
        boolean forceOutput = this.includeNonVariants || inForceOutputIntervals;
        VariantContext regenotypedVC = this.gvcfEngine.callRegion(loc, variants, ref, features, this.merger, this.somaticInput, this.tlodThreshold, this.afTolerance, forceOutput);
        if (regenotypedVC != null) {
            SimpleInterval variantStart = new SimpleInterval(regenotypedVC.getContig(), regenotypedVC.getStart(), regenotypedVC.getStart());
            if (!(!forceOutput && GATKVariantContextUtils.isSpanningDeletionOnly(regenotypedVC) || this.onlyOutputCallsStartingInIntervals && !this.intervals.stream().anyMatch(interval -> interval.contains(variantStart)))) {
                this.vcfWriter.add(regenotypedVC);
            }
        }
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }
}

