/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.cmdline.argumentcollections.DbsnpArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.ReferenceConfidenceVariantContextMerger;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.RMSMappingQuality;
import org.broadinstitute.hellbender.tools.walkers.annotator.RankSumTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_RMSMappingQuality;
import org.broadinstitute.hellbender.tools.walkers.genotyper.AlleleSubsettingUtils;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeCalculationArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypingEngine;
import org.broadinstitute.hellbender.tools.walkers.genotyper.MinimalGenotypingEngine;
import org.broadinstitute.hellbender.tools.walkers.genotyper.OutputMode;
import org.broadinstitute.hellbender.tools.walkers.genotyper.StandardCallerArgumentCollection;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;
import org.broadinstitute.hellbender.utils.genotyper.IndexedSampleList;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;

public class GenotypeGVCFsEngine {
    private static final String GVCF_BLOCK = "GVCFBlock";
    private VariantAnnotatorEngine annotationEngine = null;
    private GenotypingEngine<?> forceOutputGenotypingEngine = null;
    private MinimalGenotypingEngine genotypingEngine = null;
    private final List<String> infoFieldAnnotationKeyNamesToRemove = new ArrayList<String>();
    private GenotypeCalculationArgumentCollection genotypeArgs;
    final LinkedHashSet<String> infoHeaderAltAllelesLineNames = new LinkedHashSet();
    private boolean includeNonVariants;
    private VCFHeader outputHeader;
    private SampleList samples;
    private DragstrParams dragStrParams;
    final VCFHeader inputVCFHeader;

    public GenotypeGVCFsEngine(VariantAnnotatorEngine annotationEngine, GenotypeCalculationArgumentCollection genotypeArgs, boolean includeNonVariants, VCFHeader inputVCFHeader) {
        this.annotationEngine = annotationEngine;
        this.genotypeArgs = genotypeArgs;
        this.includeNonVariants = includeNonVariants;
        this.inputVCFHeader = inputVCFHeader;
        this.initialize();
    }

    private void initialize() {
        this.samples = new IndexedSampleList(this.inputVCFHeader.getGenotypeSamples());
        for (InfoFieldAnnotation annotation : this.annotationEngine.getInfoAnnotations()) {
            List<String> keyNames;
            if (!(annotation instanceof RankSumTest) && !(annotation instanceof AS_RMSMappingQuality) && !(annotation instanceof RMSMappingQuality) || (keyNames = annotation.getKeyNames()).isEmpty()) continue;
            this.infoFieldAnnotationKeyNamesToRemove.add(keyNames.get(0));
        }
        this.genotypingEngine = new MinimalGenotypingEngine(this.createMinimalArgs(false), this.samples, this.annotationEngine.getInfoAnnotations().stream().anyMatch(AnnotationUtils::isAlleleSpecific), this.dragStrParams);
        this.forceOutputGenotypingEngine = new MinimalGenotypingEngine(this.createMinimalArgs(true), this.samples, this.annotationEngine.getInfoAnnotations().stream().anyMatch(AnnotationUtils::isAlleleSpecific));
        if (this.includeNonVariants) {
            for (VCFHeaderLine headerLine : this.inputVCFHeader.getMetaDataInInputOrder()) {
                if (!(headerLine instanceof VCFInfoHeaderLine) || ((VCFInfoHeaderLine)headerLine).getCountType() != VCFHeaderLineCount.A) continue;
                this.infoHeaderAltAllelesLineNames.add(((VCFInfoHeaderLine)headerLine).getID());
            }
        }
    }

    public VariantContext callRegion(Locatable loc, List<VariantContext> variants, ReferenceContext ref, FeatureContext features, ReferenceConfidenceVariantContextMerger merger, boolean somaticInput, double tlodThreshold, double afTolerance, boolean outputNonVariants) {
        List<VariantContext> variantsToProcess = this.getVariantSubsetToProcess(loc, variants);
        if (this.dragStrParams == null || this.genotypeArgs.dontUseDragstrPriors) {
            ref.setWindow(10, 10);
        } else {
            ref.setWindow(this.dragStrParams.maximumLengthInBasePairs(), this.dragStrParams.maximumLengthInBasePairs());
        }
        this.genotypingEngine.setReferenceContext(ref);
        VariantContext mergedVC = merger.merge(variantsToProcess, loc, ref.getBase(), true, false);
        VariantContext regenotypedVC = somaticInput ? this.regenotypeSomaticVC(mergedVC, ref, features, outputNonVariants, tlodThreshold, afTolerance) : this.regenotypeVC(mergedVC, ref, features, outputNonVariants);
        return regenotypedVC;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VariantContext regenotypeVC(VariantContext originalVC, ReferenceContext ref, FeatureContext features, boolean includeNonVariants) {
        VariantContext reannotated;
        VariantContext result;
        Utils.nonNull(originalVC);
        if (originalVC.isVariant() && originalVC.getAttributeAsInt("DP", 0) > 0) {
            VariantContext regenotypedVC = this.calculateGenotypes(originalVC, includeNonVariants);
            if (regenotypedVC == null) {
                return null;
            }
            if (!GATKVariantContextUtils.isProperlyPolymorphic(regenotypedVC)) {
                if (!includeNonVariants) return null;
            }
            VariantContext withGenotypingAnnotations = this.addGenotypingAnnotations(originalVC.getAttributes(), regenotypedVC);
            VariantContext withAnnotations = this.annotationEngine.finalizeAnnotations(withGenotypingAnnotations, originalVC);
            int[] relevantIndices = regenotypedVC.getAlleles().stream().mapToInt(a -> originalVC.getAlleles().indexOf(a)).toArray();
            VariantContext trimmed = GATKVariantContextUtils.reverseTrimAlleles(withAnnotations);
            GenotypesContext updatedGTs = this.subsetAlleleSpecificFormatFields(this.outputHeader, trimmed.getGenotypes(), relevantIndices);
            result = new VariantContextBuilder(trimmed).genotypes(updatedGTs).make();
        } else {
            result = originalVC;
        }
        if (result.isPolymorphicInSamples()) {
            reannotated = this.annotationEngine.annotateContext(result, features, ref, null, a -> true);
            return new VariantContextBuilder(reannotated).genotypes(GenotypeGVCFsEngine.cleanupGenotypeAnnotations(reannotated, false)).make();
        }
        if (!includeNonVariants) return null;
        reannotated = new VariantContextBuilder(result).genotypes(GenotypeGVCFsEngine.cleanupGenotypeAnnotations(result, true)).make();
        return this.annotationEngine.annotateContext(reannotated, features, ref, null, GenotypeGVCFsEngine::annotationShouldBeSkippedForHomRefSites);
    }

    private static boolean annotationShouldBeSkippedForHomRefSites(VariantAnnotation annotation) {
        return annotation instanceof RankSumTest || annotation instanceof RMSMappingQuality || annotation instanceof AS_RMSMappingQuality;
    }

    private GenotypesContext subsetAlleleSpecificFormatFields(VCFHeader outputHeader, GenotypesContext originalGs, int[] relevantIndices) {
        GenotypesContext newGTs = GenotypesContext.create((int)originalGs.size());
        for (Genotype g : originalGs) {
            GenotypeBuilder gb = new GenotypeBuilder(g);
            Set keys = g.getExtendedAttributes().keySet();
            for (String key : keys) {
                VCFFormatHeaderLine headerLine = outputHeader.getFormatHeaderLine(key);
                List<Object> attribute = headerLine.getCountType().equals((Object)VCFHeaderLineCount.INTEGER) && headerLine.getCount() == 1 ? g.getAnyAttribute(key) : ReferenceConfidenceVariantContextMerger.generateAnnotationValueVector(headerLine.getCountType(), VariantContextGetters.attributeToList(g.getAnyAttribute(key)), relevantIndices);
                gb.attribute(key, attribute);
            }
            newGTs.add(gb.make());
        }
        return newGTs;
    }

    private VariantContext addGenotypingAnnotations(Map<String, Object> originalAttributes, VariantContext newVC) {
        LinkedHashMap<String, Object> attrs = new LinkedHashMap<String, Object>(originalAttributes);
        attrs.put("MLEAC", newVC.getAttribute("MLEAC"));
        attrs.put("MLEAF", newVC.getAttribute("MLEAF"));
        if (newVC.hasAttribute("NDA")) {
            attrs.put("NDA", newVC.getAttribute("NDA"));
        }
        if (newVC.hasAttribute("AS_QUAL")) {
            attrs.put("AS_QUAL", newVC.getAttribute("AS_QUAL"));
        }
        return new VariantContextBuilder(newVC).attributes(attrs).make();
    }

    private VariantContext calculateGenotypes(VariantContext vc, boolean forceOutput) {
        return (forceOutput ? this.forceOutputGenotypingEngine : this.genotypingEngine).calculateGenotypes(vc, null, Collections.emptyList());
    }

    private VariantContext regenotypeSomaticVC(VariantContext originalVC, ReferenceContext ref, FeatureContext features, boolean includeNonVariants, double tlodThreshold, double afTolerance) {
        Utils.nonNull(originalVC);
        Object result = originalVC.isVariant() && originalVC.getAttributeAsInt("DP", 0) > 0 ? this.callSomaticGenotypes(originalVC, tlodThreshold, afTolerance) : (includeNonVariants ? originalVC : null);
        return result;
    }

    private VariantContext callSomaticGenotypes(VariantContext vc, double tlodThreshold, double afTolerance) {
        ArrayList<Genotype> newGenotypes = new ArrayList<Genotype>();
        GenotypesContext genotypes = vc.getGenotypes();
        double[] perAlleleLikelihoodSums = new double[vc.getAlleles().size()];
        for (Genotype g : genotypes) {
            GenotypeBuilder gb = new GenotypeBuilder(g);
            double[] tlodArray = VariantContextGetters.getAttributeAsDoubleArray(g, "TLOD", () -> null, 0.0);
            double[] variantAFArray = VariantContextGetters.getAttributeAsDoubleArray(g, "AF", () -> null, 0.0);
            double variantAFtotal = 0.0;
            ArrayList<Allele> calledAlleles = new ArrayList<Allele>();
            for (int i = 0; i < vc.getAlleles().size() - 1; ++i) {
                variantAFtotal += variantAFArray[i];
                if (!(tlodArray[i] > tlodThreshold)) continue;
                calledAlleles.add(vc.getAlternateAllele(i));
                int n = i + 1;
                perAlleleLikelihoodSums[n] = perAlleleLikelihoodSums[n] + tlodArray[i];
            }
            if (variantAFtotal < 1.0 - afTolerance && (!g.hasAD() || g.getAD()[0] > 0)) {
                calledAlleles.add(0, vc.getReference());
            }
            gb.alleles(calledAlleles);
            newGenotypes.add(gb.make());
        }
        VariantContextBuilder builder = new VariantContextBuilder(vc);
        VariantContext regenotypedVC = builder.genotypes(newGenotypes).make();
        int maxAltAlleles = ((StandardCallerArgumentCollection)this.genotypingEngine.getConfiguration()).genotypeArgs.MAX_ALTERNATE_ALLELES;
        List<Allele> allelesToKeep = new ArrayList<Allele>(perAlleleLikelihoodSums.length - 1);
        allelesToKeep.add(vc.getReference());
        for (int i = 1; i < perAlleleLikelihoodSums.length; ++i) {
            if (!(perAlleleLikelihoodSums[i] > tlodThreshold)) continue;
            allelesToKeep.add(vc.getAlternateAllele(i - 1));
        }
        if (regenotypedVC.getAlternateAlleles().size() > maxAltAlleles) {
            allelesToKeep = AlleleSubsettingUtils.filterToMaxNumberOfAltAllelesBasedOnScores(maxAltAlleles, allelesToKeep, perAlleleLikelihoodSums);
        }
        if (allelesToKeep.size() == 1) {
            return null;
        }
        if (allelesToKeep.size() == regenotypedVC.getAlleles().size()) {
            return regenotypedVC;
        }
        int[] relevantIndices = allelesToKeep.stream().mapToInt(a -> regenotypedVC.getAlleles().indexOf(a)).toArray();
        GenotypesContext reducedGenotypes = AlleleSubsettingUtils.subsetSomaticAlleles(this.outputHeader, regenotypedVC.getGenotypes(), allelesToKeep, relevantIndices);
        VariantContext subsetVC = builder.alleles(allelesToKeep).genotypes(reducedGenotypes).make();
        VariantContext trimmedVC = GATKVariantContextUtils.trimAlleles(subsetVC, true, true);
        if (GATKVariantContextUtils.isProperlyPolymorphic(trimmedVC)) {
            return trimmedVC;
        }
        return null;
    }

    private List<VariantContext> getVariantSubsetToProcess(Locatable loc, List<VariantContext> preProcessedVariants) {
        if (this.includeNonVariants) {
            List<VariantContext> matchingStart = preProcessedVariants.stream().filter(vc -> vc.getStart() == loc.getStart()).collect(Collectors.toList());
            if (matchingStart.size() == 0) {
                return preProcessedVariants;
            }
            if (matchingStart.size() == 1) {
                return matchingStart;
            }
            throw new IllegalStateException(String.format("Variant input contains more than one variant starting at location: %s", new SimpleInterval((Locatable)matchingStart.get(0))));
        }
        return preProcessedVariants;
    }

    private StandardCallerArgumentCollection createMinimalArgs(boolean forceOutput) {
        StandardCallerArgumentCollection args = new StandardCallerArgumentCollection();
        args.genotypeArgs = this.genotypeArgs.clone();
        args.outputMode = forceOutput ? OutputMode.EMIT_ALL_ACTIVE_SITES : OutputMode.EMIT_VARIANTS_ONLY;
        return args;
    }

    public VariantContextWriter setupVCFWriter(Set<VCFHeaderLine> defaultToolVCFHeaderLines, boolean keepCombined, DbsnpArgumentCollection dbsnp, VariantContextWriter vcfWriter) {
        LinkedHashSet<Object> headerLines = new LinkedHashSet<Object>(this.inputVCFHeader.getMetaDataInInputOrder());
        headerLines.addAll(defaultToolVCFHeaderLines);
        headerLines.removeIf(vcfHeaderLine -> vcfHeaderLine.getKey().startsWith(GVCF_BLOCK));
        headerLines.addAll(this.annotationEngine.getVCFAnnotationDescriptions(false));
        headerLines.addAll(this.genotypingEngine.getAppropriateVCFInfoHeaders());
        headerLines.add(GATKVCFHeaderLines.getInfoLine("MLEAC"));
        headerLines.add(GATKVCFHeaderLines.getInfoLine("MLEAF"));
        headerLines.add(GATKVCFHeaderLines.getFormatLine("RGQ"));
        headerLines.add(VCFStandardHeaderLines.getInfoLine((String)"DP"));
        if (keepCombined) {
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_QUAL"));
            headerLines.add(GATKVCFHeaderLines.getInfoLine("AS_QUALapprox"));
        }
        if (dbsnp.dbsnp != null) {
            VCFStandardHeaderLines.addStandardInfoLines(headerLines, (boolean)true, (String[])new String[]{"DB"});
        }
        headerLines.add(GATKVCFHeaderLines.getFilterLine("LowQual"));
        Set<String> sampleNameSet = this.samples.asSetOfSamples();
        this.outputHeader = new VCFHeader(headerLines, new TreeSet<String>(sampleNameSet));
        vcfWriter.writeHeader(this.outputHeader);
        return vcfWriter;
    }

    @VisibleForTesting
    static List<Genotype> cleanupGenotypeAnnotations(VariantContext vc, boolean createRefGTs) {
        GenotypesContext oldGTs = vc.getGenotypes();
        ArrayList<Genotype> recoveredGs = new ArrayList<Genotype>(oldGTs.size());
        for (Genotype oldGT : oldGTs) {
            int depth;
            HashMap<String, Object> attrs = new HashMap<String, Object>(oldGT.getExtendedAttributes());
            GenotypeBuilder builder = new GenotypeBuilder(oldGT);
            int n = depth = oldGT.hasDP() ? oldGT.getDP() : 0;
            if (oldGT.hasExtendedAttribute("MIN_DP")) {
                depth = GenotypeGVCFsEngine.parseInt(oldGT.getAnyAttribute("MIN_DP"));
                builder.DP(depth);
                attrs.remove("MIN_DP");
            }
            attrs.remove("SB");
            if (oldGT.isHomVar() && oldGT.hasExtendedAttribute("PGT")) {
                attrs.put("PGT", "1|1");
            }
            if (!oldGT.hasAD() && vc.isVariant()) {
                int[] AD = new int[vc.getNAlleles()];
                AD[0] = depth;
                builder.AD(AD);
            }
            if (createRefGTs) {
                if (oldGT.hasGQ()) {
                    builder.noGQ();
                    attrs.put("RGQ", oldGT.getGQ());
                }
                if (depth > 0 && oldGT.hasGQ() && oldGT.getGQ() > 0) {
                    List<Allele> refAlleles = Collections.nCopies(oldGT.getPloidy(), vc.getReference());
                    builder.alleles(refAlleles);
                }
                builder.noPL();
            }
            recoveredGs.add(builder.noAttributes().attributes(attrs).make());
        }
        return recoveredGs;
    }

    private static int parseInt(Object attribute) {
        if (attribute instanceof String) {
            return Integer.parseInt((String)attribute);
        }
        if (attribute instanceof Number) {
            return ((Number)attribute).intValue();
        }
        throw new IllegalArgumentException("Expected a Number or a String but found something else.");
    }
}

