/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.programgroups.MethylationProgramGroup;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.LocusWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;

@CommandLineProgramProperties(summary="Tool that prints methylation-based coverage from supplied bisulfite sequenced, methylation-aware aligned BAM to the specified output vcf file", oneLineSummary="Identify methylated bases from bisulfite sequenced, methylation-aware BAMs", programGroup=MethylationProgramGroup.class)
@DocumentedFeature
@ExperimentalFeature
public class MethylationTypeCaller
extends LocusWalker {
    @Argument(fullName="output", shortName="O", doc="Output VCF file")
    private GATKPath outputFile;
    private VariantContextWriter vcfWriter;
    private static final int REFERENCE_CONTEXT_LENGTH = 2;

    @Override
    public void onTraversalStart() {
        this.vcfWriter = this.createVCFWriter(this.outputFile.toPath());
        this.vcfWriter.writeHeader(MethylationTypeCaller.createMethylationHeader(this.getHeaderForReads(), this.getDefaultToolVCFHeaderLines()));
    }

    private static VCFHeader createMethylationHeader(SAMFileHeader header, Set<VCFHeaderLine> headerLines) {
        if (header == null) {
            throw new UserException.BadInput("Error writing header, getHeaderForReads() returns null");
        }
        VCFInfoHeaderLine unconvertedCoverageLine = new VCFInfoHeaderLine("UNCONVERTED_BASE_COV", 1, VCFHeaderLineType.Integer, "Count of reads supporting methylation that are unconverted ");
        VCFInfoHeaderLine coverageLine = new VCFInfoHeaderLine("CONVERTED_BASE_COV", 1, VCFHeaderLineType.Integer, "Count of reads supporting methylation that are converted ");
        VCFInfoHeaderLine contextLine = new VCFInfoHeaderLine("REFERENCE_CONTEXT", 1, VCFHeaderLineType.String, "Forward Strand Reference context");
        VCFInfoHeaderLine readDepthLine = VCFStandardHeaderLines.getInfoLine((String)"DP");
        VCFFormatHeaderLine gtLine = VCFStandardHeaderLines.getFormatLine((String)"GT");
        headerLines.add((VCFHeaderLine)unconvertedCoverageLine);
        headerLines.add((VCFHeaderLine)coverageLine);
        headerLines.add((VCFHeaderLine)contextLine);
        headerLines.add((VCFHeaderLine)readDepthLine);
        headerLines.add((VCFHeaderLine)gtLine);
        List samples = header.getReadGroups().stream().map(SAMReadGroupRecord::getSample).sorted().distinct().collect(Collectors.toList());
        return new VCFHeader(headerLines, samples);
    }

    @Override
    public void apply(AlignmentContext alignmentContext, ReferenceContext referenceContext, FeatureContext featureContext) {
        int convertedBases;
        int unconvertedBases;
        byte alt;
        byte referenceBase = referenceContext.getBases()[0];
        byte[] context = null;
        if (referenceBase == 67) {
            alt = 84;
            ReadPileup forwardBasePileup = alignmentContext.stratify(AlignmentContext.ReadOrientation.FORWARD).getBasePileup();
            int[] forwardBaseCounts = forwardBasePileup.getBaseCounts();
            unconvertedBases = forwardBaseCounts[BaseUtils.simpleBaseToBaseIndex((byte)67)];
            if (unconvertedBases + (convertedBases = forwardBaseCounts[BaseUtils.simpleBaseToBaseIndex((byte)84)]) > 0) {
                context = referenceContext.getBases(0, 2);
            }
        } else if (referenceBase == 71) {
            alt = 65;
            ReadPileup reverseBasePileup = alignmentContext.stratify(AlignmentContext.ReadOrientation.REVERSE).getBasePileup();
            int[] reverseBaseCounts = reverseBasePileup.getBaseCounts();
            unconvertedBases = reverseBaseCounts[BaseUtils.simpleBaseToBaseIndex((byte)71)];
            if (unconvertedBases + (convertedBases = reverseBaseCounts[BaseUtils.simpleBaseToBaseIndex((byte)65)]) > 0) {
                context = BaseUtils.simpleReverseComplement(referenceContext.getBases(2, 0));
            }
        } else {
            return;
        }
        if (context != null) {
            LinkedHashSet<Allele> alleles = new LinkedHashSet<Allele>();
            alleles.add(Allele.create((byte)referenceBase, (boolean)true));
            alleles.add(Allele.create((byte)alt, (boolean)false));
            VariantContextBuilder vcb = new VariantContextBuilder();
            vcb.chr(alignmentContext.getContig());
            vcb.start(alignmentContext.getPosition());
            vcb.stop(alignmentContext.getPosition());
            vcb.noID();
            vcb.alleles(alleles);
            vcb.noGenotypes();
            vcb.unfiltered();
            vcb.attribute("UNCONVERTED_BASE_COV", (Object)unconvertedBases);
            vcb.attribute("CONVERTED_BASE_COV", (Object)convertedBases);
            vcb.attribute("REFERENCE_CONTEXT", (Object)new String(context));
            vcb.attribute("DP", (Object)alignmentContext.size());
            VariantContext vc = vcb.make();
            this.vcfWriter.add(vc);
        }
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }

    @Override
    public boolean requiresReference() {
        return true;
    }
}

