/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.ArrayList;
import java.util.List;
import org.aeonbits.owner.util.Collections;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.AlignmentAgreesWithHeaderReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.OtherProgramGroup;

@CommandLineProgramProperties(summary="Replace bases in reads with reference bases.", oneLineSummary="Replace bases in reads with reference bases.", programGroup=OtherProgramGroup.class)
@DocumentedFeature
@ExperimentalFeature
@WorkflowProperties
public final class ReadAnonymizer
extends ReadWalker {
    @Argument(fullName="output", shortName="O", doc="Output bam file.")
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    public GATKPath output;
    @Argument(fullName="ref-base-quality", shortName="ref-base-quality", doc="Quality for bases that are set to the reference base.", minValue=0.0, maxValue=60.0, optional=true)
    public int refQual = 60;
    @Argument(fullName="use-simple-cigar", shortName="use-simple-cigar", doc="If true, will produce a simplified cigar string (without `=` and `X`).", optional=true)
    public boolean useSimpleCigar = false;
    private SAMFileGATKReadWriter outputWriter;

    @Override
    public boolean requiresReference() {
        return true;
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.list((Object[])new ReadFilter[]{ReadFilterLibrary.VALID_ALIGNMENT_START, ReadFilterLibrary.VALID_ALIGNMENT_END, ReadFilterLibrary.READLENGTH_EQUALS_CIGARLENGTH, ReadFilterLibrary.SEQ_IS_STORED, ReadFilterLibrary.HAS_MATCHING_BASES_AND_QUALS, ReadFilterLibrary.MAPPED, new AlignmentAgreesWithHeaderReadFilter()});
    }

    @Override
    public void onTraversalStart() {
        this.outputWriter = this.createSAMWriter(this.output, false);
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        GATKRead sanitizedRead = this.anonymizeRead(read, referenceContext);
        this.outputWriter.addRead(sanitizedRead);
    }

    private GATKRead anonymizeRead(GATKRead read, ReferenceContext referenceContext) {
        SimpleInterval readInterval = new SimpleInterval(read.getContig(), read.getStart(), read.getEnd());
        byte[] readBases = read.getBasesNoCopy();
        byte[] readbaseQuals = read.getBaseQualitiesNoCopy();
        byte[] refBases = referenceContext.getBases(readInterval);
        ArrayList<Byte> newReadBases = new ArrayList<Byte>();
        ArrayList<Byte> newBaseQualities = new ArrayList<Byte>();
        ArrayList<CigarElement> newCigar = new ArrayList<CigarElement>();
        int readIndex = 0;
        int refIndex = 0;
        CigarOperator currentNewCigarOp = null;
        int currentNewCigarOpCount = 0;
        CigarOperator iterCigarOp = null;
        int iterCigarOpCount = 0;
        for (CigarElement cigarElement : read.getCigar().getCigarElements()) {
            switch (cigarElement.getOperator()) {
                case H: 
                case N: 
                case P: {
                    iterCigarOp = cigarElement.getOperator();
                    iterCigarOpCount = cigarElement.getLength();
                    break;
                }
                case S: 
                case EQ: {
                    int i;
                    for (i = 0; i < cigarElement.getLength(); ++i) {
                        newReadBases.add(readBases[readIndex + i]);
                        newBaseQualities.add(readbaseQuals[readIndex + i]);
                    }
                    iterCigarOp = cigarElement.getOperator();
                    iterCigarOpCount = cigarElement.getLength();
                    break;
                }
                case M: {
                    int i;
                    for (i = 0; i < cigarElement.getLength(); ++i) {
                        newReadBases.add(refBases[refIndex + i]);
                        if (readBases[readIndex + i] == refBases[refIndex + i]) {
                            newBaseQualities.add(readbaseQuals[readIndex + i]);
                            continue;
                        }
                        newBaseQualities.add((byte)this.refQual);
                    }
                    iterCigarOp = this.useSimpleCigar ? CigarOperator.M : CigarOperator.EQ;
                    iterCigarOpCount = cigarElement.getLength();
                    break;
                }
                case X: 
                case D: {
                    int i;
                    for (i = 0; i < cigarElement.getLength(); ++i) {
                        newReadBases.add(refBases[refIndex + i]);
                        newBaseQualities.add((byte)this.refQual);
                    }
                    iterCigarOp = this.useSimpleCigar ? CigarOperator.M : CigarOperator.EQ;
                    iterCigarOpCount = cigarElement.getLength();
                    break;
                }
                case I: {
                    iterCigarOp = currentNewCigarOp;
                    iterCigarOpCount = 0;
                    break;
                }
                default: {
                    throw new UserException.MalformedFile("Unexpected cigar operation: " + cigarElement.toString());
                }
            }
            if (iterCigarOp == currentNewCigarOp) {
                currentNewCigarOpCount += iterCigarOpCount;
            } else {
                if (currentNewCigarOp != null) {
                    newCigar.add(new CigarElement(currentNewCigarOpCount, currentNewCigarOp));
                }
                currentNewCigarOp = iterCigarOp;
                currentNewCigarOpCount = iterCigarOpCount;
            }
            if (cigarElement.getOperator().consumesReferenceBases()) {
                refIndex += cigarElement.getLength();
            }
            if (!cigarElement.getOperator().consumesReadBases()) continue;
            readIndex += cigarElement.getLength();
        }
        newCigar.add(new CigarElement(currentNewCigarOpCount, currentNewCigarOp));
        read.setCigar(new Cigar(newCigar));
        Byte[] newBases = newReadBases.toArray(new Byte[newReadBases.size()]);
        read.setBases(ArrayUtils.toPrimitive((Byte[])newBases));
        Byte[] newQualitites = newBaseQualities.toArray(new Byte[newBaseQualities.size()]);
        read.setBaseQualities(ArrayUtils.toPrimitive((Byte[])newQualitites));
        String readGroup = read.getReadGroup();
        read.clearAttributes();
        read.setReadGroup(readGroup);
        return read;
    }

    @Override
    public void closeTool() {
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
    }
}

