/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotationData;
import org.broadinstitute.hellbender.tools.walkers.genotyper.AlleleSubsettingUtils;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculators;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.variant.GATKVCFConstants;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;

public final class ReferenceConfidenceVariantContextMerger {
    private static final GenotypeLikelihoodCalculators calculators = new GenotypeLikelihoodCalculators();
    private static VCFHeader vcfInputHeader = null;
    protected final VariantAnnotatorEngine annotatorEngine;
    private final boolean doSomaticMerge;
    protected boolean dropSomaticFilteringAnnotations;
    protected final OneShotLogger oneShotAnnotationLogger = new OneShotLogger(this.getClass());
    protected final OneShotLogger oneShotHeaderLineLogger = new OneShotLogger(this.getClass());
    protected final OneShotLogger AS_Warning = new OneShotLogger(this.getClass());
    List<String> SOMATIC_INFO_ANNOTATIONS_TO_MOVE = Arrays.asList("TLOD");
    private static final List<String> SOMATIC_FORMAT_ANNOTATIONS_TO_KEEP = Arrays.asList("OCM", "PGT", "PID", "PS");
    private static final List<String> SOMATIC_INFO_ANNOTATIONS_TO_DROP = Arrays.asList("POPAF");

    public ReferenceConfidenceVariantContextMerger(VariantAnnotatorEngine engine, VCFHeader inputHeader) {
        this(engine, inputHeader, false, false);
    }

    public ReferenceConfidenceVariantContextMerger(VariantAnnotatorEngine engine, VCFHeader inputHeader, boolean somaticInput) {
        this(engine, inputHeader, somaticInput, false);
    }

    public ReferenceConfidenceVariantContextMerger(VariantAnnotatorEngine engine, VCFHeader inputHeader, boolean somaticInput, boolean dropSomaticFilteringAnnotations) {
        Utils.nonNull(inputHeader, "A VCF header must be provided");
        this.annotatorEngine = engine;
        vcfInputHeader = inputHeader;
        this.doSomaticMerge = somaticInput;
        this.dropSomaticFilteringAnnotations = dropSomaticFilteringAnnotations;
    }

    public VariantContext merge(List<VariantContext> vcs, Locatable loc, Byte refBase, boolean removeNonRefSymbolicAllele, boolean samplesAreUniquified) {
        Utils.nonEmpty(vcs);
        String name = vcs.get(0).getSource();
        Allele refAllele = ReferenceConfidenceVariantContextMerger.determineReferenceAlleleGivenReferenceBase(vcs, loc, refBase);
        if (refAllele == null) {
            return null;
        }
        ArrayList<VCWithNewAlleles> vcAndNewAllelePairs = new ArrayList<VCWithNewAlleles>(vcs.size());
        HashSet aggregatedFilters = new HashSet();
        boolean sawPassSample = false;
        for (VariantContext vc : vcs) {
            boolean isSpanningEvent = loc.getStart() != vc.getStart();
            vcAndNewAllelePairs.add(new VCWithNewAlleles(vc, isSpanningEvent ? ReferenceConfidenceVariantContextMerger.replaceWithNoCallsAndDels(vc, this.doSomaticMerge) : ReferenceConfidenceVariantContextMerger.remapAlleles(vc, refAllele), isSpanningEvent));
            if (!this.doSomaticMerge || !vc.filtersWereApplied()) continue;
            if (vc.isFiltered()) {
                aggregatedFilters.addAll(vc.getFilters());
                continue;
            }
            sawPassSample = true;
        }
        List<Allele> allelesList = ReferenceConfidenceVariantContextMerger.collectTargetAlleles(vcAndNewAllelePairs, refAllele, removeNonRefSymbolicAllele);
        LinkedHashSet<String> rsIDs = new LinkedHashSet<String>(1);
        int depth = 0;
        LinkedHashMap annotationMap = new LinkedHashMap();
        GenotypesContext genotypes = GenotypesContext.create();
        for (VCWithNewAlleles vcWithNewAlleles : vcAndNewAllelePairs) {
            VariantContext vc = vcWithNewAlleles.getVc();
            List<Allele> remappedAlleles = vcWithNewAlleles.getNewAlleles();
            genotypes.addAll((Collection)this.mergeRefConfidenceGenotypes(vc, remappedAlleles, allelesList, samplesAreUniquified));
            depth += ReferenceConfidenceVariantContextMerger.calculateVCDepth(vc);
            if (loc.getStart() != vc.getStart()) continue;
            if (vc.hasID()) {
                rsIDs.add(vc.getID());
            }
            this.addReferenceConfidenceAttributes(vcWithNewAlleles, annotationMap);
        }
        Map<String, Object> attributes = this.mergeAttributes(depth, allelesList, annotationMap);
        String ID = rsIDs.isEmpty() ? "." : String.join((CharSequence)",", rsIDs);
        VariantContextBuilder builder = new VariantContextBuilder().source(name).id(ID).alleles(allelesList).chr(loc.getContig()).start((long)loc.getStart()).computeEndFromAlleles(ReferenceConfidenceVariantContextMerger.nonSymbolicAlleles(allelesList), loc.getStart(), loc.getStart()).genotypes(genotypes).unfiltered().attributes(new TreeMap<String, Object>(attributes)).log10PError(1.0);
        if (this.doSomaticMerge) {
            if (aggregatedFilters.isEmpty() || sawPassSample) {
                builder.passFilters();
            } else {
                builder.filters(aggregatedFilters);
            }
        }
        return builder.make();
    }

    private static List<Allele> replaceWithNoCallsAndDels(VariantContext vc, boolean doSomaticMerge) {
        Utils.nonNull(vc);
        ArrayList<Allele> result = new ArrayList<Allele>(vc.getNAlleles());
        result.add(Allele.NO_CALL);
        for (Allele allele : vc.getAlternateAlleles()) {
            Allele replacement = allele.equals((Object)Allele.NON_REF_ALLELE) ? allele : (!doSomaticMerge && allele.length() < vc.getReference().length() ? Allele.SPAN_DEL : Allele.NO_CALL);
            result.add(replacement);
        }
        return result;
    }

    public static List<Allele> remapAlleles(VariantContext vc, Allele refAllele) {
        Allele vcRef = vc.getReference();
        byte[] refBases = refAllele.getBases();
        int extraBaseCount = refBases.length - vcRef.getBases().length;
        if (extraBaseCount < 0) {
            throw new IllegalStateException("the wrong reference was selected");
        }
        ArrayList<Allele> result = new ArrayList<Allele>(vc.getNAlleles());
        result.add(refAllele);
        for (Allele a : vc.getAlternateAlleles()) {
            if (a.isSymbolic()) {
                result.add(a);
                continue;
            }
            if (a == Allele.SPAN_DEL) {
                result.add(a);
                continue;
            }
            if (a.isCalled()) {
                result.add(ReferenceConfidenceVariantContextMerger.extendAllele(a, extraBaseCount, refBases));
                continue;
            }
            result.add(a);
        }
        return result;
    }

    private static List<Allele> collectTargetAlleles(List<VCWithNewAlleles> vcAndNewAllelePairs, Allele refAllele, boolean removeNonRefSymbolicAllele) {
        LinkedHashSet<Allele> finalAlleleSet = new LinkedHashSet<Allele>(10);
        finalAlleleSet.add(refAllele);
        vcAndNewAllelePairs.stream().flatMap(rec$ -> ((VCWithNewAlleles)rec$).filterAllelesForFinalSet()).forEachOrdered(finalAlleleSet::add);
        boolean sawSpanningDeletion = vcAndNewAllelePairs.stream().anyMatch(VCWithNewAlleles::isSpanningDeletion);
        boolean sawNonSpanningEvent = vcAndNewAllelePairs.stream().anyMatch(VCWithNewAlleles::isNonSpanningEvent);
        if (sawSpanningDeletion && (sawNonSpanningEvent || !removeNonRefSymbolicAllele)) {
            finalAlleleSet.add(Allele.SPAN_DEL);
        }
        if (!removeNonRefSymbolicAllele) {
            finalAlleleSet.add(Allele.NON_REF_ALLELE);
        }
        return new ArrayList<Allele>(finalAlleleSet);
    }

    protected static int calculateVCDepth(VariantContext vc) {
        if (vc.hasAttribute("DP")) {
            return vc.getAttributeAsInt("DP", 0);
        }
        return vc.getGenotypes().stream().mapToInt(ReferenceConfidenceVariantContextMerger::getBestDepthValue).sum();
    }

    private Map<String, Object> mergeAttributes(int depth, List<Allele> alleleList, Map<String, List<?>> annotationMap) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.putAll(this.annotatorEngine.combineAnnotations(alleleList, annotationMap));
        for (String key : annotationMap.keySet()) {
            List<?> values = annotationMap.get(key);
            if (values == null || values.size() <= 0) continue;
            int size = values.size();
            if (size == 1) {
                attributes.put(key, values.get(0));
                continue;
            }
            attributes.put(key, Utils.getMedianValue(values));
        }
        if (depth > 0) {
            attributes.put("DP", String.valueOf(depth));
        }
        ReferenceConfidenceVariantContextMerger.removeStaleAttributesAfterMerge(attributes);
        return attributes;
    }

    @VisibleForTesting
    static int getBestDepthValue(Genotype gt) {
        if (gt.hasExtendedAttribute("MIN_DP")) {
            return Integer.parseInt(gt.getAnyAttribute("MIN_DP").toString());
        }
        return gt.hasDP() ? gt.getDP() : 0;
    }

    private static List<Allele> nonSymbolicAlleles(List<Allele> alleles) {
        return alleles.stream().filter(a -> !a.isSymbolic()).collect(Collectors.toList());
    }

    private static Allele determineReferenceAlleleGivenReferenceBase(List<VariantContext> VCs, Locatable loc, Byte refBase) {
        Allele refAllele = GATKVariantContextUtils.determineReferenceAllele(VCs, loc);
        if (refAllele == null) {
            if (refBase == null) {
                return null;
            }
            return Allele.create((byte)refBase, (boolean)true);
        }
        return refAllele;
    }

    protected static void removeStaleAttributesAfterMerge(Map<String, Object> attributes) {
        attributes.remove("AC");
        attributes.remove("AF");
        attributes.remove("AN");
        attributes.remove("MLEAC");
        attributes.remove("MLEAF");
        attributes.remove("END");
        attributes.remove("ECNT");
    }

    @VisibleForTesting
    private void addReferenceConfidenceAttributes(VCWithNewAlleles vcPair, Map<String, List<?>> annotationMap) {
        for (Map.Entry p : vcPair.getVc().getAttributes().entrySet()) {
            List<?> values;
            String key = (String)p.getKey();
            if (this.SOMATIC_INFO_ANNOTATIONS_TO_MOVE.contains(key) || SOMATIC_INFO_ANNOTATIONS_TO_DROP.contains(key) || Mutect2FilteringEngine.STANDARD_MUTECT_INFO_FIELDS_FOR_FILTERING.contains(key)) continue;
            if (this.annotatorEngine.isRequestedReducibleRawKey(key)) {
                List valueList = vcPair.getVc().getAttributeAsList(key);
                values = annotationMap.get(key);
                if (values == null) {
                    values = new ArrayList();
                    annotationMap.put(key, values);
                }
                StringJoiner joiner = new StringJoiner(",");
                for (Object s : valueList) {
                    joiner.add(s.toString());
                }
                AlleleSpecificAnnotationData pairData = new AlleleSpecificAnnotationData(vcPair.getNewAlleles(), joiner.toString());
                values.add(pairData);
                continue;
            }
            Object value = p.getValue();
            values = annotationMap.get(key);
            if (values == null) {
                values = new ArrayList();
                annotationMap.put(key, values);
            }
            try {
                String[] valueArray;
                if (!value.toString().contains(",")) {
                    values.add(this.parseNumericInfoAttributeValue(vcfInputHeader, key, value.toString()));
                    continue;
                }
                for (String val : valueArray = value.toString().split("\\[|,|\\]")) {
                    if (val.equals("")) continue;
                    values.add(this.parseNumericInfoAttributeValue(vcfInputHeader, key, val.toString()));
                }
            }
            catch (NumberFormatException e) {
                this.oneShotAnnotationLogger.warn(String.format("Detected invalid annotations: When trying to merge variant contexts at location %s:%d the annotation %s was not a numerical value and was ignored", vcPair.getVc().getContig(), vcPair.getVc().getStart(), p.toString()));
                if (!key.startsWith("AS")) continue;
                this.AS_Warning.warn(String.format("Reducible annotation '%s' detected, add -G StandardAnnotation -G AS_StandardAnnotation to the command to annotate in the final VC with this annotation.", key));
            }
        }
    }

    private Comparable<?> parseNumericInfoAttributeValue(VCFHeader vcfHeader, String key, String stringValue) {
        VCFInfoHeaderLine infoLine = vcfHeader.getInfoHeaderLine(key);
        if (infoLine == null) {
            this.oneShotHeaderLineLogger.warn(String.format("At least one attribute was found (%s) for which there is no corresponding header line", key));
            if (stringValue.contains(".")) {
                return Double.parseDouble(stringValue);
            }
            return Integer.parseInt(stringValue);
        }
        switch (infoLine.getType()) {
            case Integer: {
                return Integer.parseInt(stringValue);
            }
            case Float: {
                return Double.parseDouble(stringValue);
            }
        }
        throw new NumberFormatException(String.format("The VCF header specifies type %s type for INFO attribute key %s, but a numeric value is required", infoLine.getType().name(), key));
    }

    private static Allele extendAllele(Allele allele, int extraBaseCount, byte[] refBases) {
        if (extraBaseCount > 0) {
            byte[] oldBases = allele.getBases();
            byte[] newBases = Arrays.copyOf(oldBases, oldBases.length + extraBaseCount);
            System.arraycopy(refBases, refBases.length - extraBaseCount, newBases, oldBases.length, extraBaseCount);
            return Allele.create((byte[])newBases, (boolean)false);
        }
        return allele;
    }

    private GenotypesContext mergeRefConfidenceGenotypes(VariantContext vc, List<Allele> remappedAlleles, List<Allele> targetAlleles, boolean samplesAreUniquified) {
        GenotypesContext mergedGenotypes = GenotypesContext.create();
        int maximumPloidy = vc.getMaxPloidy(2);
        int[][] genotypeIndexMapsByPloidy = new int[maximumPloidy + 1][];
        int maximumAlleleCount = Math.max(remappedAlleles.size(), targetAlleles.size());
        for (Genotype g : vc.getGenotypes()) {
            Object perSampleIndexesOfRelevantAlleles;
            String name = samplesAreUniquified ? g.getSampleName() + "." + vc.getSource() : g.getSampleName();
            int ploidy = g.getPloidy();
            GenotypeBuilder genotypeBuilder = new GenotypeBuilder(g);
            if (!this.doSomaticMerge) {
                if (g.hasPL()) {
                    perSampleIndexesOfRelevantAlleles = AlleleSubsettingUtils.getIndexesOfRelevantAllelesForGVCF(remappedAlleles, targetAlleles, vc.getStart(), g, false);
                    int[] genotypeIndexMapByPloidy = genotypeIndexMapsByPloidy[ploidy] == null ? calculators.getInstance(ploidy, maximumAlleleCount).genotypeIndexMap((int[])perSampleIndexesOfRelevantAlleles, calculators) : genotypeIndexMapsByPloidy[ploidy];
                    int[] PLs = ReferenceConfidenceVariantContextMerger.generatePL(g, genotypeIndexMapByPloidy);
                    int[] AD = g.hasAD() ? AlleleSubsettingUtils.generateAD(g.getAD(), (int[])perSampleIndexesOfRelevantAlleles) : null;
                    genotypeBuilder.PL(PLs).AD(AD);
                }
            } else {
                int[] AD;
                genotypeBuilder.noAttributes();
                if (g.hasDP()) {
                    genotypeBuilder.DP(g.getDP());
                }
                for (String key : SOMATIC_FORMAT_ANNOTATIONS_TO_KEEP) {
                    if (!g.hasExtendedAttribute(key)) continue;
                    genotypeBuilder.attribute(key, g.getExtendedAttribute(key));
                }
                perSampleIndexesOfRelevantAlleles = AlleleSubsettingUtils.getIndexesOfRelevantAllelesForGVCF(remappedAlleles, targetAlleles, vc.getStart(), g, false);
                int nonRefIndex = remappedAlleles.indexOf(Allele.NON_REF_ALLELE);
                if (g.hasAD()) {
                    AD = AlleleSubsettingUtils.generateAD(g.getAD(), (int[])perSampleIndexesOfRelevantAlleles);
                    genotypeBuilder.AD(AD);
                } else if (g.hasDP()) {
                    AD = new int[targetAlleles.size()];
                    AD[0] = g.getDP();
                    genotypeBuilder.AD(AD);
                }
                if (g.hasExtendedAttribute("AF")) {
                    double[] AF = AlleleSubsettingUtils.generateAF(VariantContextGetters.getAttributeAsDoubleArray(g, "AF", () -> new double[]{0.0}, 0.0), (int[])perSampleIndexesOfRelevantAlleles);
                    genotypeBuilder.attribute("AF", (Object)AF);
                } else if ((g.isHomRef() || g.isNoCall()) && vc.getAlternateAlleles().size() == 1) {
                    genotypeBuilder.attribute("AF", (Object)new double[targetAlleles.size() - 1]);
                }
                for (String key : this.SOMATIC_INFO_ANNOTATIONS_TO_MOVE) {
                    this.setPerSampleSomaticAttributes(vc, (int[])perSampleIndexesOfRelevantAlleles, g, genotypeBuilder, key);
                }
                if (!this.dropSomaticFilteringAnnotations) {
                    for (String key : Mutect2FilteringEngine.STANDARD_MUTECT_INFO_FIELDS_FOR_FILTERING) {
                        this.setPerSampleSomaticAttributes(vc, (int[])perSampleIndexesOfRelevantAlleles, g, genotypeBuilder, key);
                    }
                }
                if (vc.filtersWereApplied() && vc.getSampleNames().size() == 1 && !g.isHomRef() && !vc.getFilters().isEmpty()) {
                    genotypeBuilder.filters(new ArrayList(vc.getFilters()));
                }
            }
            genotypeBuilder.alleles(GATKVariantContextUtils.noCallAlleles(g.getPloidy())).name(name);
            mergedGenotypes.add(genotypeBuilder.make());
        }
        return mergedGenotypes;
    }

    private void setPerSampleSomaticAttributes(VariantContext vc, int[] perSampleIndexesOfRelevantAlleles, Genotype g, GenotypeBuilder genotypeBuilder, String somaticKey) {
        List<Object> originalTLODs;
        VCFHeaderLineCount attributeCount;
        List<Object> newTLODs;
        if (g.hasExtendedAttribute(somaticKey)) {
            List<Object> originalTLODs2;
            VCFHeaderLineCount attributeCount2 = vcfInputHeader.getFormatHeaderLine(somaticKey).getCountType();
            List<Object> newTLODs2 = ReferenceConfidenceVariantContextMerger.generateAnnotationValueVector(attributeCount2, originalTLODs2 = VariantContextGetters.attributeToList(g.getAnyAttribute(somaticKey)), perSampleIndexesOfRelevantAlleles);
            if (newTLODs2 != null) {
                genotypeBuilder.attribute(somaticKey, newTLODs2);
            }
        } else if (vc.hasAttribute(somaticKey) && (newTLODs = ReferenceConfidenceVariantContextMerger.generateAnnotationValueVector(attributeCount = vcfInputHeader.getInfoHeaderLine(somaticKey).getCountType(), originalTLODs = VariantContextGetters.attributeToList(vc.getAttribute(somaticKey)), perSampleIndexesOfRelevantAlleles)) != null) {
            genotypeBuilder.attribute(somaticKey, newTLODs);
        }
    }

    private static int[] generatePL(Genotype g, int[] genotypeIndexMapByPloidy) {
        int[] PLs = new int[genotypeIndexMapByPloidy.length];
        int[] oldPLs = g.getPL();
        for (int i = 0; i < PLs.length; ++i) {
            PLs[i] = oldPLs[genotypeIndexMapByPloidy[i]];
        }
        return PLs;
    }

    @VisibleForTesting
    public static <T> List<T> generateAnnotationValueVector(VCFHeaderLineCount alleleCount, List<T> originalList, int[] indexesOfRelevantAlleles) {
        List<Object> newLODs = null;
        newLODs = alleleCount.equals((Object)VCFHeaderLineCount.A) ? AlleleSubsettingUtils.remapALengthList(originalList, indexesOfRelevantAlleles, null) : (alleleCount.equals((Object)VCFHeaderLineCount.R) ? AlleleSubsettingUtils.remapRLengthList(originalList, indexesOfRelevantAlleles, null) : originalList);
        return newLODs;
    }

    @VisibleForTesting
    protected static class VCWithNewAlleles {
        private final VariantContext vc;
        private final List<Allele> newAlleles;
        private final boolean isSpanningEvent;

        VCWithNewAlleles(VariantContext vc, List<Allele> newAlleles, boolean isSpanningEvent) {
            this.vc = vc;
            this.newAlleles = newAlleles;
            this.isSpanningEvent = isSpanningEvent;
        }

        private Stream<Allele> filterAllelesForFinalSet() {
            return this.newAlleles.stream().filter(a -> !a.equals((Object)Allele.NON_REF_ALLELE)).filter(a -> !a.isReference()).filter(a -> !a.isSymbolic() || !this.vc.isSymbolic()).filter(Allele::isCalled);
        }

        boolean isSpanningDeletion() {
            return this.isSpanningEvent && this.vc.isMixed() || this.vc.getAlleles().contains(Allele.SPAN_DEL) || this.vc.getAlleles().contains(GATKVCFConstants.SPANNING_DELETION_SYMBOLIC_ALLELE_DEPRECATED);
        }

        boolean isNonSpanningEvent() {
            return !this.isSpanningEvent && this.vc.isMixed();
        }

        public VariantContext getVc() {
            return this.vc;
        }

        List<Allele> getNewAlleles() {
            return this.newAlleles;
        }
    }
}

