/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers;

import java.util.Collections;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Simple tool to revert the quality scores in a SAM/BAM/CRAM file. Copies the scores from the OQ tag to the quality scores.", oneLineSummary="Revert Quality Scores in a SAM/BAM/CRAM file", usageExample="hellbender RevertQualityScores -I input.bam -O output.bam", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public class RevertBaseQualityScores
extends ReadWalker {
    @Argument(fullName="output", shortName="O", doc="Write output to this file")
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    public GATKPath OUTPUT;
    private SAMFileGATKReadWriter outputWriter;

    @Override
    public void onTraversalStart() {
        this.outputWriter = this.createSAMWriter(this.OUTPUT, true);
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(ReadFilterLibrary.ALLOW_ALL_READS);
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        byte[] originalQuals = ReadUtils.getOriginalBaseQualities(read);
        if (originalQuals == null) {
            throw new UserException("RevertQualityScores can only be applied to SAM/BAM files with original quality scores, caused by read: " + read.getName());
        }
        read.setBaseQualities(originalQuals);
        this.outputWriter.addRead(read);
    }

    @Override
    public void closeTool() {
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
    }
}

