/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.GATKTool;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import picard.cmdline.programgroups.IntervalsManipulationProgramGroup;
import picard.util.IntervalList.IntervalListScatterMode;
import picard.util.IntervalList.IntervalListScatterer;

@CommandLineProgramProperties(summary="Split intervals into sub-interval files.", oneLineSummary="Split intervals into sub-interval files.", programGroup=IntervalsManipulationProgramGroup.class)
@DocumentedFeature
public class SplitIntervals
extends GATKTool {
    public static final String SCATTER_COUNT_SHORT_NAME = "scatter";
    public static final String SCATTER_COUNT_LONG_NAME = "scatter-count";
    public static final String SUBDIVISION_MODE_SHORT_NAME = "mode";
    public static final String SUBDIVISION_MODE_lONG_NAME = "subdivision-mode";
    public static final String DONT_MIX_CONTIGS_LONG_NAME = "dont-mix-contigs";
    public static final String MIN_CONTIG_SIZE_LONG_NAME = "min-contig-size";
    public static final String INTERVAL_FILE_EXTENSION_FULL_NAME = "extension";
    public static final String PICARD_INTERVAL_FILE_EXTENSION = "interval_list";
    public static final String DEFAULT_EXTENSION = "-scattered.interval_list";
    public static final int DEFAULT_NUMBER_OF_DIGITS = 4;
    @Argument(fullName="scatter-count", shortName="scatter", doc="scatter count: number of output interval files to split into", optional=true)
    private int scatterCount = 1;
    @Argument(fullName="min-contig-size", doc="Minimum contig size to keep if getting intervals from the reference", optional=true)
    private int minContigSize = 0;
    @Argument(fullName="subdivision-mode", shortName="mode", doc="How to divide intervals.")
    private IntervalListScatterMode subdivisionMode = IntervalListScatterMode.INTERVAL_SUBDIVISION;
    @Argument(doc="The directory into which to write the scattered interval sub-directories.", fullName="output", shortName="O")
    public File outputDir;
    @Argument(doc="Extension to use when writing interval files", fullName="extension", optional=true)
    public String extension = "-scattered.interval_list";
    @Argument(doc="Scattered interval files do not contain intervals from multiple contigs.  This is applied after the initial scatter, so that the requested scatter count is a lower bound on the number of actual scattered files.", fullName="dont-mix-contigs", optional=true)
    public boolean dontMixContigs = false;

    @Override
    public void onTraversalStart() {
        ParamUtils.isPositive(this.scatterCount, "scatter-count must be > 0.");
        if (!this.outputDir.exists() && !this.outputDir.mkdir()) {
            throw new RuntimeIOException("Unable to create directory: " + this.outputDir.getAbsolutePath());
        }
        SAMSequenceDictionary sequenceDictionary = this.getBestAvailableSequenceDictionary();
        List<SimpleInterval> intervals = this.hasUserSuppliedIntervals() ? this.intervalArgumentCollection.getIntervals(sequenceDictionary) : IntervalUtils.getAllIntervalsForReference(sequenceDictionary).stream().filter(contig -> contig.getLengthOnReference() >= this.minContigSize).collect(Collectors.toList());
        IntervalList intervalList = new IntervalList(sequenceDictionary);
        intervals.stream().map(si -> new Interval(si.getContig(), si.getStart(), si.getEnd())).forEach(arg_0 -> ((IntervalList)intervalList).add(arg_0));
        IntervalListScatterer scatterer = this.subdivisionMode.make();
        List scattered = scatterer.scatter(intervalList, this.scatterCount);
        List scatteredFinal = !this.dontMixContigs ? scattered : scattered.stream().flatMap(il -> il.getIntervals().stream().collect(Collectors.groupingBy(Interval::getContig)).entrySet().stream().sorted(Comparator.comparingInt(entry -> sequenceDictionary.getSequenceIndex((String)entry.getKey()))).map(entry -> (List)entry.getValue()).map(list -> {
            IntervalList singleContigList = new IntervalList(sequenceDictionary);
            singleContigList.addall((Collection)list);
            return singleContigList;
        })).collect(Collectors.toList());
        int maxNumberOfPlaces = Math.max((int)Math.floor(Math.log10(this.scatterCount - 1)) + 1, 4);
        String formatString = "%0" + maxNumberOfPlaces + "d";
        IntStream.range(0, scatteredFinal.size()).forEach(n -> ((IntervalList)scatteredFinal.get(n)).write(new File(this.outputDir, String.format(formatString, n) + this.extension)));
    }

    @Override
    public void traverse() {
    }
}

