/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers;

import java.util.Collections;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.argparser.WorkflowProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReadWalker;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Simple tool to unmark duplicates in a SAM/BAM/CRAM file. Clears the 0x400 SAM flag bit on all reads.", oneLineSummary="Clears the 0x400 duplicate SAM flag", usageExample="gatk UnmarkDuplicates -I marked_duplicates.bam -O unmarked_duplicates.bam", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
@WorkflowProperties
public class UnmarkDuplicates
extends ReadWalker {
    static final String USAGE_SUMMARY = "Clears the 0x400 duplicate SAM flag";
    static final String USAGE_DETAILS = "Simple tool to unmark duplicates in a SAM/BAM/CRAM file. Clears the 0x400 SAM flag bit on all reads.";
    @Argument(fullName="output", shortName="O", doc="Write output to this file")
    @WorkflowOutput(optionalCompanions={"outputIndex"})
    public GATKPath OUTPUT;
    private SAMFileGATKReadWriter outputWriter;

    @Override
    public void onTraversalStart() {
        this.outputWriter = this.createSAMWriter(this.OUTPUT, true);
    }

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Collections.singletonList(ReadFilterLibrary.ALLOW_ALL_READS);
    }

    @Override
    public void apply(GATKRead read, ReferenceContext referenceContext, FeatureContext featureContext) {
        read.setIsDuplicate(false);
        this.outputWriter.addRead(read);
    }

    @Override
    public void closeTool() {
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
    }
}

