/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardMutectAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StrandBiasBySample;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.StrandBiasUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class AS_StrandBiasMutectAnnotation
extends InfoFieldAnnotation
implements StandardMutectAnnotation,
AlleleSpecificAnnotation {
    private static final Logger logger = LogManager.getLogger(StrandBiasBySample.class);

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (likelihoods == null) {
            logger.warn("Annotation will not be calculated, alleleLikelihoodMap is null");
            return null;
        }
        return StrandBiasUtils.computeSBAnnotation(vc, likelihoods, "AS_SB_TABLE");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return super.getDescriptions();
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("AS_SB_TABLE");
    }
}

