/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.DepthPerAlleleBySample;
import org.broadinstitute.hellbender.tools.walkers.annotator.GenotypeAnnotation;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Variant allele fraction for a genotype")
public final class AlleleFraction
extends GenotypeAnnotation {
    @Override
    public void annotate(ReferenceContext ref, VariantContext vc, Genotype g, GenotypeBuilder gb, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(gb, "gb is null");
        Utils.nonNull(vc, "vc is null");
        GenotypesContext genotypes = vc.getGenotypes();
        if (g == null || !g.isCalled() || g.hasExtendedAttribute(this.getKeyNames().get(0))) {
            return;
        }
        if (g.hasAD()) {
            int[] AD = g.getAD();
            double[] allAlleleFractions = MathUtils.normalizeSumToOne(Arrays.stream(AD).mapToDouble(x -> x).toArray());
            gb.attribute(this.getKeyNames().get(0), (Object)Arrays.copyOfRange(allAlleleFractions, 1, allAlleleFractions.length));
        } else if (likelihoods != null) {
            DepthPerAlleleBySample adCalc = new DepthPerAlleleBySample();
            int[] AD = adCalc.annotateWithLikelihoods(vc, g, new LinkedHashSet<Allele>(vc.getAlleles()), likelihoods);
            double[] allAlleleFractions = MathUtils.normalizeSumToOne(Arrays.stream(AD).mapToDouble(x -> (double)x * 1.0).toArray());
            gb.attribute(this.getKeyNames().get(0), (Object)Arrays.copyOfRange(allAlleleFractions, 1, allAlleleFractions.length));
        }
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("AF");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Collections.singletonList(GATKVCFHeaderLines.getFormatLine(this.getKeyNames().get(0)));
    }
}

