/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotation;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class AnnotationUtils {
    public static final String ALLELE_SPECIFIC_RAW_DELIM = "|";
    public static final String ALLELE_SPECIFIC_REDUCED_DELIM = ",";
    public static final String ALLELE_SPECIFIC_SPLIT_REGEX = "\\|";
    public static final String BRACKET_REGEX = "\\[|\\]";
    public static final String LIST_DELIMITER = ",";

    private AnnotationUtils() {
    }

    public static String encodeValueList(List<Double> valueList, String precisionFormat) {
        ArrayList<String> outputList = new ArrayList<String>();
        for (Double d : valueList) {
            outputList.add(String.format(precisionFormat, d));
        }
        return StringUtils.join(outputList, (String)",");
    }

    public static String encodeStringList(List<String> stringList) {
        return StringUtils.join(stringList, (String)",");
    }

    public static String encodeAnyASListWithRawDelim(List<?> somethingList) {
        return StringUtils.join(somethingList, (String)ALLELE_SPECIFIC_RAW_DELIM).replaceAll(BRACKET_REGEX, "");
    }

    public static List<String> decodeAnyASListWithRawDelim(String somethingList) {
        return Arrays.asList(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)somethingList.replaceAll(BRACKET_REGEX, ""), (String)ALLELE_SPECIFIC_RAW_DELIM));
    }

    public static List<String> decodeAnyASList(String somethingList) {
        return Arrays.asList(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)somethingList.replaceAll(BRACKET_REGEX, ""), (String)","));
    }

    public static boolean isAlleleSpecific(InfoFieldAnnotation annotation) {
        return annotation instanceof AlleleSpecificAnnotation;
    }

    public static List<String> getAlleleLengthListOfString(String rawDataString) {
        if (rawDataString == null) {
            return Collections.emptyList();
        }
        if (rawDataString.startsWith("[")) {
            rawDataString = rawDataString.substring(1, rawDataString.length() - 1).replaceAll("\\s", "");
        }
        return Arrays.asList(rawDataString.split(ALLELE_SPECIFIC_SPLIT_REGEX));
    }

    static String generateMissingDataWarning(VariantContext vc, Genotype g, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        StringBuilder outString = new StringBuilder("Annotation will not be calculated at position " + vc.getContig() + ":" + vc.getStart() + " and possibly subsequent");
        if (!g.isCalled()) {
            outString.append("; genotype for sample " + g.getSampleName() + " is not called");
        }
        if (likelihoods == null) {
            outString.append("; alleleLikelihoodMap is null");
        }
        return outString.toString();
    }
}

