/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.primitives.Ints;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import org.apache.commons.math3.util.FastMath;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.tools.walkers.annotator.BaseQualityRankSumTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.PerAlleleAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardMutectAnnotation;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Median base quality of bases supporting each allele (MBQ)")
public class BaseQuality
extends PerAlleleAnnotation
implements StandardMutectAnnotation {
    @Override
    protected int aggregate(List<Integer> values) {
        return values.isEmpty() ? 0 : MathUtils.median(Ints.toArray(values));
    }

    @Override
    protected String getVcfKey() {
        return "MBQ";
    }

    @Override
    protected String getDescription() {
        return "median base quality";
    }

    @Override
    protected boolean includeRefAllele() {
        return true;
    }

    @Override
    protected OptionalInt getValueForRead(GATKRead read, VariantContext vc) {
        return BaseQuality.getBaseQuality(read, vc);
    }

    public static OptionalInt getBaseQuality(GATKRead read, VariantContext vc) {
        if (vc.getStart() < read.getStart() || read.getEnd() < vc.getStart()) {
            return OptionalInt.empty();
        }
        OptionalDouble result = BaseQualityRankSumTest.getReadBaseQuality(read, vc);
        return result.isPresent() ? OptionalInt.of((int)FastMath.round((double)result.getAsDouble())) : OptionalInt.empty();
    }
}

