/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.TreeMultiset;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.BaseQuality;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class BaseQualityHistogram
extends InfoFieldAnnotation {
    public static final String KEY = "BQHIST";

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (likelihoods == null) {
            return Collections.emptyMap();
        }
        Map<Allele, TreeMultiset> values = likelihoods.alleles().stream().collect(Collectors.toMap(a -> a, a -> TreeMultiset.create()));
        Utils.stream(likelihoods.bestAllelesBreakingTies()).filter(ba -> ba.isInformative() && BaseQualityHistogram.isUsableRead((GATKRead)ba.evidence)).forEach(ba -> BaseQuality.getBaseQuality((GATKRead)ba.evidence, vc).ifPresent(v -> ((TreeMultiset)values.get(ba.allele)).add((Object)v)));
        List distinctBaseQualities = likelihoods.alleles().stream().flatMap(a -> ((TreeMultiset)values.get(a)).stream()).distinct().sorted().collect(Collectors.toList());
        ArrayList<Integer> output = new ArrayList<Integer>();
        Iterator iterator = distinctBaseQualities.iterator();
        while (iterator.hasNext()) {
            int qual = (Integer)iterator.next();
            output.add(qual);
            likelihoods.alleles().forEach(allele -> output.add(((TreeMultiset)values.get(allele)).count((Object)qual)));
        }
        return ImmutableMap.of((Object)KEY, output);
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(KEY, VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Base quality counts for each allele represented sparsely as alternating entries of qualities and counts for each allele.For example [10,1,0,20,0,1] means one ref base with quality 10 and one alt base with quality 20."));
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList(KEY);
    }

    private static boolean isUsableRead(GATKRead read) {
        return read.getMappingQuality() != 0 && read.getMappingQuality() != 255;
    }
}

