/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.tools.walkers.annotator.RankSumTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Rank sum test of REF versus ALT base quality scores (BaseQRankSum)")
public final class BaseQualityRankSumTest
extends RankSumTest
implements StandardAnnotation {
    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("BaseQRankSum");
    }

    @Override
    protected OptionalDouble getElementForRead(GATKRead read, VariantContext vc) {
        return BaseQualityRankSumTest.getReadBaseQuality(read, vc);
    }

    public static OptionalDouble getReadBaseQuality(GATKRead read, VariantContext vc) {
        Utils.nonNull(read);
        Optional<Byte> readBaseQuality = ReadUtils.getReadBaseQualityAtReferenceCoordinate(read, vc.getStart());
        return readBaseQuality.isPresent() ? OptionalDouble.of(readBaseQuality.get().byteValue()) : OptionalDouble.empty();
    }
}

