/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Counts and frequency of alleles in called genotypes (AC, AF, AN)")
public final class ChromosomeCounts
extends InfoFieldAnnotation
implements StandardAnnotation {
    public static final String[] keyNames = new String[]{"AN", "AC", "AF"};
    public static final VCFInfoHeaderLine[] descriptions = new VCFInfoHeaderLine[]{VCFStandardHeaderLines.getInfoLine((String)"AF"), VCFStandardHeaderLines.getInfoLine((String)"AC"), VCFStandardHeaderLines.getInfoLine((String)"AN")};

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (!vc.hasGenotypes()) {
            return Collections.emptyMap();
        }
        return VariantContextUtils.calculateChromosomeCounts((VariantContext)vc, new LinkedHashMap(), (boolean)true, Collections.emptySet());
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList(keyNames);
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(descriptions);
    }
}

