/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardMutectAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Total depth of coverage per sample and over all samples (DP)")
public final class Coverage
extends InfoFieldAnnotation
implements StandardAnnotation,
StandardMutectAnnotation {
    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (likelihoods == null || likelihoods.evidenceCount() == 0) {
            return Collections.emptyMap();
        }
        int depth = likelihoods.evidenceCount();
        return Collections.singletonMap(this.getKeyNames().get(0), String.format("%d", depth));
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("DP");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Collections.singletonList(VCFStandardHeaderLines.getInfoLine((String)this.getKeyNames().get(0)));
    }
}

