/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.GenotypeAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardMutectAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Depth of coverage of each allele per sample (AD)")
public final class DepthPerAlleleBySample
extends GenotypeAnnotation
implements StandardAnnotation,
StandardMutectAnnotation {
    @Override
    public void annotate(ReferenceContext ref, VariantContext vc, Genotype g, GenotypeBuilder gb, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(gb, "gb is null");
        Utils.nonNull(vc, "vc is null");
        if (g == null || !g.isCalled() || likelihoods == null) {
            return;
        }
        LinkedHashSet<Allele> alleles = new LinkedHashSet<Allele>(vc.getAlleles());
        Utils.validateArg(likelihoods.alleles().containsAll(alleles), () -> "VC alleles " + alleles + " not a  subset of AlleleLikelihoods alleles " + likelihoods.alleles());
        gb.AD(this.annotateWithLikelihoods(vc, g, alleles, likelihoods));
    }

    protected int[] annotateWithLikelihoods(VariantContext vc, Genotype g, Set<Allele> alleles, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        LinkedHashMap<Allele, Integer> alleleCounts = new LinkedHashMap<Allele, Integer>();
        for (Allele allele : vc.getAlleles()) {
            alleleCounts.put(allele, 0);
        }
        Map<Allele, List> alleleSubset = alleles.stream().collect(Collectors.toMap(a -> a, xva$0 -> Arrays.asList(xva$0)));
        AlleleLikelihoods<GATKRead, Allele> subsettedLikelihoods = likelihoods.marginalize(alleleSubset);
        subsettedLikelihoods.bestAllelesBreakingTies(g.getSampleName()).stream().filter(ba -> ba.isInformative()).forEach(ba -> alleleCounts.compute((Allele)ba.allele, (allele, prevCount) -> prevCount + 1));
        int[] counts = new int[alleleCounts.size()];
        counts[0] = (Integer)alleleCounts.get(vc.getReference());
        for (int i = 0; i < vc.getNAlleles() - 1; ++i) {
            counts[i + 1] = (Integer)alleleCounts.get(vc.getAlternateAllele(i));
        }
        return counts;
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("AD");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Collections.singletonList(VCFStandardHeaderLines.getFormatLine((String)this.getKeyNames().get(0)));
    }
}

