/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.stat.StatUtils;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.PedigreeAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotationData;
import org.broadinstitute.hellbender.utils.GenotypeCounts;
import org.broadinstitute.hellbender.utils.GenotypeUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Phred-scaled p-value for exact test of excess heterozygosity (ExcessHet)")
public final class ExcessHet
extends PedigreeAnnotation
implements StandardAnnotation {
    private static final double MIN_NEEDED_VALUE = 1.0E-16;
    private static final boolean ROUND_GENOTYPE_COUNTS = true;
    public static final double PHRED_SCALED_MIN_P_VALUE = -10.0 * Math.log10(1.0E-16);
    public static final int NUMBER_OF_GENOTYPE_COUNTS = 3;

    public ExcessHet(Set<String> founderIds) {
        super(founderIds);
    }

    public ExcessHet(GATKPath pedigreeFile) {
        super(pedigreeFile);
    }

    public ExcessHet() {
        this((Set<String>)null);
    }

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        GenotypesContext genotypes = this.getFounderGenotypes(vc);
        if (genotypes == null || !vc.isVariant()) {
            return Collections.emptyMap();
        }
        Pair<Integer, Double> sampleCountEH = ExcessHet.calculateEH(vc, genotypes);
        int sampleCount = (Integer)sampleCountEH.getLeft();
        double eh = (Double)sampleCountEH.getRight();
        if (sampleCount < 1) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.getKeyNames().get(0), String.format("%.4f", eh));
    }

    @VisibleForTesting
    static Pair<Integer, Double> calculateEH(VariantContext vc, GenotypesContext genotypes) {
        GenotypeCounts t = GenotypeUtils.computeDiploidGenotypeCounts(vc, genotypes, true);
        int sampleCount = (int)genotypes.stream().filter(g -> GenotypeUtils.isDiploidWithLikelihoods(g)).count();
        return ExcessHet.calculateEH(vc, t, sampleCount);
    }

    @VisibleForTesting
    public static Pair<Integer, Double> calculateEH(VariantContext vc, GenotypeCounts t, int sampleCount) {
        int homCount;
        int refCount = (int)t.getRefs();
        int hetCount = (int)t.getHets();
        double pval = ExcessHet.exactTest(hetCount, refCount, homCount = (int)t.getHoms());
        if (pval < 1.0E-59) {
            return Pair.of((Object)sampleCount, (Object)PHRED_SCALED_MIN_P_VALUE);
        }
        double phredPval = -10.0 * Math.log10(pval);
        return Pair.of((Object)sampleCount, (Object)phredPval);
    }

    @VisibleForTesting
    static double exactTest(int hetCount, int refCount, int homCount) {
        double potentialProb;
        int obsHomC;
        int obsHomR;
        Utils.validateArg(hetCount >= 0, "Het count cannot be less than 0");
        Utils.validateArg(refCount >= 0, "Ref count cannot be less than 0");
        Utils.validateArg(homCount >= 0, "Hom count cannot be less than 0");
        if (refCount < homCount) {
            obsHomR = refCount;
            obsHomC = homCount;
        } else {
            obsHomR = homCount;
            obsHomC = refCount;
        }
        int rareCopies = 2 * obsHomR + hetCount;
        int N = hetCount + obsHomC + obsHomR;
        if (rareCopies <= 1) {
            return 0.5;
        }
        double[] probs = new double[rareCopies + 1];
        int mid = (int)Math.floor((double)rareCopies * (2.0 * (double)N - (double)rareCopies) / (2.0 * (double)N - 1.0));
        if (mid % 2 != rareCopies % 2) {
            ++mid;
        }
        probs[mid] = 1.0;
        double mysum = 1.0;
        int currHets = mid;
        int currHomR = (rareCopies - mid) / 2;
        int currHomC = N - currHets - currHomR;
        while (currHets >= 2 && !((potentialProb = probs[currHets] * (double)currHets * ((double)currHets - 1.0) / (4.0 * ((double)currHomR + 1.0) * ((double)currHomC + 1.0))) < 1.0E-16)) {
            probs[currHets - 2] = potentialProb;
            mysum += probs[currHets - 2];
            currHets -= 2;
            ++currHomR;
            ++currHomC;
        }
        currHets = mid;
        currHomR = (rareCopies - mid) / 2;
        currHomC = N - currHets - currHomR;
        while (currHets <= rareCopies - 2 && !((potentialProb = probs[currHets] * 4.0 * (double)currHomR * (double)currHomC / (((double)currHets + 2.0) * ((double)currHets + 1.0))) < 1.0E-16)) {
            probs[currHets + 2] = potentialProb;
            mysum += probs[currHets + 2];
            currHets += 2;
            --currHomR;
            --currHomC;
        }
        double rightPval = probs[hetCount] / (2.0 * mysum);
        if (hetCount == rareCopies) {
            return rightPval;
        }
        return rightPval + StatUtils.sum((double[])Arrays.copyOfRange(probs, hetCount + 1, probs.length)) / mysum;
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("ExcessHet");
    }

    public String getRawKeyName() {
        return "RAW_GT_COUNT";
    }

    public Map<String, Object> annotateRawData(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        return null;
    }

    public Map<String, Object> combineRawData(List<Allele> allelesList, List<ReducibleAnnotationData<?>> listOfRawData) {
        return null;
    }

    public Map<String, Object> finalizeRawData(VariantContext vc, VariantContext originalVC) {
        if (vc.hasAttribute(this.getRawKeyName())) {
            List counts = vc.getAttributeAsIntList(this.getRawKeyName(), 0);
            if (counts.size() != 3) {
                throw new IllegalStateException("Genotype counts for ExcessHet (" + this.getRawKeyName() + ") should have three values: homozygous reference, heterozygous with one ref allele, and homozygous variant/heterozygous non-reference");
            }
            GenotypeCounts t = new GenotypeCounts(((Integer)counts.get(0)).intValue(), ((Integer)counts.get(1)).intValue(), ((Integer)counts.get(2)).intValue());
            Pair<Integer, Double> sampleCountEH = ExcessHet.calculateEH(vc, t, (Integer)counts.get(0) + (Integer)counts.get(1) + (Integer)counts.get(2));
            int sampleCount = (Integer)sampleCountEH.getLeft();
            double eh = (Double)sampleCountEH.getRight();
            if (sampleCount < 1) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(this.getKeyNames().get(0), String.format("%.4f", eh));
        }
        return null;
    }
}

