/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StrandBiasTest;
import org.broadinstitute.hellbender.utils.FisherExactTest;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Strand bias estimated using Fisher's exact test (FS)")
public final class FisherStrand
extends StrandBiasTest
implements StandardAnnotation {
    static final double MIN_PVALUE = 1.0E-320;
    private static final int MIN_COUNT = 2;
    private static final int MIN_QUAL_FOR_FILTERED_TEST = 17;
    private static final double TARGET_TABLE_SIZE = 200.0;

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("FS");
    }

    @Override
    protected Map<String, Object> calculateAnnotationFromGTfield(GenotypesContext genotypes) {
        int[][] tableFromPerSampleAnnotations = this.getTableFromSamples(genotypes, 2);
        return tableFromPerSampleAnnotations != null ? this.annotationForOneTable(FisherStrand.pValueForContingencyTable(tableFromPerSampleAnnotations)) : null;
    }

    @Override
    protected Map<String, Object> calculateAnnotationFromLikelihoods(AlleleLikelihoods<GATKRead, Allele> likelihoods, VariantContext vc) {
        int[][] table = FisherStrand.getContingencyTable(likelihoods, vc, 2);
        return this.annotationForOneTable(FisherStrand.pValueForContingencyTable(table));
    }

    @VisibleForTesting
    Map<String, Object> annotationForOneTable(double pValue) {
        return Collections.singletonMap(this.getKeyNames().get(0), FisherStrand.makeValueObjectForAnnotation(pValue));
    }

    public static String makeValueObjectForAnnotation(int[][] originalTable) {
        return FisherStrand.makeValueObjectForAnnotation(FisherStrand.pValueForContingencyTable(originalTable));
    }

    public static String makeValueObjectForAnnotation(double pValue) {
        return String.format("%.3f", QualityUtils.phredScaleErrorRate(Math.max(pValue, 1.0E-320)));
    }

    public static Double pValueForContingencyTable(int[][] originalTable) {
        int[][] normalizedTable = FisherStrand.normalizeContingencyTable(originalTable);
        return FisherExactTest.twoSidedPValue(normalizedTable);
    }

    private static int[][] normalizeContingencyTable(int[][] table) {
        int[] nArray = new int[]{table[0][0], table[0][1], table[1][0], table[1][1]};
        int sum = FisherStrand.addExact(nArray);
        if ((double)sum <= 400.0) {
            return table;
        }
        double normFactor = (double)sum / 200.0;
        return new int[][]{{(int)((double)table[0][0] / normFactor), (int)((double)table[0][1] / normFactor)}, {(int)((double)table[1][0] / normFactor), (int)((double)table[1][1] / normFactor)}};
    }

    private static int addExact(int ... ints) {
        int res = ints[0];
        for (int i = 1; i < ints.length; ++i) {
            res = Math.addExact(res, ints[i]);
        }
        return res;
    }
}

