/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Summary of genotype statistics from all samples (NCC, GQ_MEAN, GQ_STDDEV)")
public final class GenotypeSummaries
extends InfoFieldAnnotation {
    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (!vc.hasGenotypes()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> returnMap = new LinkedHashMap<String, Object>();
        returnMap.put("NCC", vc.getNoCallCount());
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (Genotype g : vc.getGenotypes()) {
            if (!g.hasGQ()) continue;
            stats.addValue((double)g.getGQ());
        }
        if (stats.getN() > 0L) {
            returnMap.put("GQ_MEAN", String.format("%.2f", stats.getMean()));
            if (stats.getN() > 1L) {
                returnMap.put("GQ_STDDEV", String.format("%.2f", stats.getStandardDeviation()));
            }
        }
        return returnMap;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("NCC", "GQ_MEAN", "GQ_STDDEV");
    }
}

