/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;

public final class HeterozygosityCalculator {
    private static final boolean RETURN_ROUNDED = false;
    private int sampleCount = -1;
    private Map<Allele, Double> hetCounts;
    private Map<Allele, Double> alleleCounts;
    private final boolean returnRounded = false;
    private final VariantContext vc;

    public HeterozygosityCalculator(VariantContext vc) {
        this.vc = vc;
        this.doGenotypeCalculations();
    }

    private void doGenotypeCalculations() {
        GenotypesContext genotypes = this.vc.getGenotypes();
        if (genotypes == null || !this.vc.isVariant()) {
            return;
        }
        int numAlleles = this.vc.getNAlleles();
        this.sampleCount = 0;
        if (this.hetCounts == null && this.alleleCounts == null) {
            this.hetCounts = new HashMap<Allele, Double>();
            this.alleleCounts = new HashMap<Allele, Double>();
            for (Allele a : this.vc.getAlleles()) {
                if (a.isNonReference()) {
                    this.hetCounts.put(a, 0.0);
                }
                this.alleleCounts.put(a, 0.0);
            }
            for (Genotype g : genotypes) {
                if (!g.isCalled() || !g.hasLikelihoods() || g.getPloidy() != 2) continue;
                ++this.sampleCount;
                int altIndex = 0;
                for (Allele a : this.vc.getAlternateAlleles()) {
                    ++altIndex;
                    double[] normalizedLikelihoods = MathUtils.normalizeFromLog10ToLinearSpace(g.getLikelihoods().getAsVector());
                    for (int i = 0; i < numAlleles; ++i) {
                        if (i == altIndex) {
                            double currentAlleleCounts = this.alleleCounts.get(a);
                            this.alleleCounts.put(a, currentAlleleCounts + 2.0 * normalizedLikelihoods[GenotypeLikelihoods.calculatePLindex((int)altIndex, (int)altIndex)]);
                            continue;
                        }
                        int idxAB = GenotypeLikelihoods.calculatePLindex((int)Math.min(i, altIndex), (int)Math.max(i, altIndex));
                        double aHetCounts = this.hetCounts.get(a);
                        this.hetCounts.put(a, aHetCounts + normalizedLikelihoods[idxAB]);
                        double currentAlleleCounts = this.alleleCounts.get(a);
                        this.alleleCounts.put(a, currentAlleleCounts + normalizedLikelihoods[idxAB]);
                        double refAlleleCounts = this.alleleCounts.get(this.vc.getReference());
                        this.alleleCounts.put(this.vc.getReference(), refAlleleCounts + normalizedLikelihoods[idxAB]);
                    }
                    double refAlleleCounts = this.alleleCounts.get(this.vc.getReference());
                    this.alleleCounts.put(this.vc.getReference(), refAlleleCounts + 2.0 * normalizedLikelihoods[0]);
                }
            }
        }
    }

    public double getHetCount(Allele altAllele) {
        Utils.nonNull(altAllele);
        return this.hetCounts.containsKey(altAllele) ? this.hetCounts.get(altAllele) : 0.0;
    }

    public double getAlleleCount(Allele allele) {
        Utils.nonNull(allele);
        return this.alleleCounts.containsKey(allele) ? this.alleleCounts.get(allele) : 0.0;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }
}

