/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.PedigreeAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.utils.GenotypeCounts;
import org.broadinstitute.hellbender.utils.GenotypeUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Likelihood-based test for the consanguinity among samples (InbreedingCoeff)")
public final class InbreedingCoeff
extends PedigreeAnnotation
implements StandardAnnotation {
    private static final OneShotLogger oneShotLogger = new OneShotLogger(InbreedingCoeff.class);
    private static final int MIN_SAMPLES = 10;
    private static final boolean ROUND_GENOTYPE_COUNTS = false;

    public InbreedingCoeff() {
        super((Set<String>)null);
    }

    public InbreedingCoeff(Set<String> founderIds) {
        super(founderIds);
    }

    public InbreedingCoeff(GATKPath pedigreeFile) {
        super(pedigreeFile);
    }

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        GenotypesContext genotypes = this.getFounderGenotypes(vc);
        if (genotypes == null || genotypes.size() < 10 || !vc.isVariant()) {
            oneShotLogger.warn("InbreedingCoeff will not be calculated at position " + vc.getContig() + ":" + vc.getStart() + " and possibly subsequent; at least " + 10 + " samples must have called genotypes");
            return Collections.emptyMap();
        }
        Pair<Integer, Double> sampleCountCoeff = InbreedingCoeff.calculateIC(vc, genotypes);
        int sampleCount = (Integer)sampleCountCoeff.getLeft();
        double F = (Double)sampleCountCoeff.getRight();
        if (sampleCount < 10) {
            oneShotLogger.warn("InbreedingCoeff will not be calculated for at least one position; at least 10 samples must have called genotypes");
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.getKeyNames().get(0), String.format("%.4f", F));
    }

    @VisibleForTesting
    static Pair<Integer, Double> calculateIC(VariantContext vc, GenotypesContext genotypes) {
        GenotypeCounts t = GenotypeUtils.computeDiploidGenotypeCounts(vc, genotypes, false);
        double refCount = t.getRefs();
        double hetCount = t.getHets();
        double homCount = t.getHoms();
        int sampleCount = (int)genotypes.stream().filter(g -> GenotypeUtils.isDiploidWithLikelihoods(g)).count();
        double p = (2.0 * refCount + hetCount) / (2.0 * (refCount + hetCount + homCount));
        double q = 1.0 - p;
        double expectedHets = 2.0 * p * q * (double)sampleCount;
        double F = 1.0 - hetCount / expectedHets;
        return Pair.of((Object)sampleCount, (Object)F);
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("InbreedingCoeff");
    }
}

