/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.OptionalDouble;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.tools.walkers.annotator.RankSumTest;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Rank sum test of per-read likelihoods of REF versus ALT reads (LikelihoodRankSum)")
public final class LikelihoodRankSumTest
extends RankSumTest {
    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("LikelihoodRankSum");
    }

    @Override
    protected OptionalDouble getElementForRead(GATKRead read, VariantContext vc, AlleleLikelihoods.BestAllele bestAllele) {
        Utils.nonNull(read, "read is null");
        Utils.nonNull(bestAllele, "mostLikelyAllele is null");
        if (!bestAllele.isInformative()) {
            throw new IllegalStateException("Should never see a non-informative allele for read " + read + " BestAllele " + bestAllele);
        }
        return OptionalDouble.of(bestAllele.likelihood);
    }

    @Override
    protected OptionalDouble getElementForRead(GATKRead read, VariantContext vc) {
        return OptionalDouble.empty();
    }
}

