/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.primitives.Ints;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.List;
import java.util.OptionalInt;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.tools.walkers.annotator.PerAlleleAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardMutectAnnotation;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Median mapping quality of reads supporting each allele (MMQ)")
public class MappingQuality
extends PerAlleleAnnotation
implements StandardMutectAnnotation {
    private static final int VALUE_FOR_NO_READS = 60;

    @Override
    protected int aggregate(List<Integer> values) {
        return values.isEmpty() ? 60 : MathUtils.median(Ints.toArray(values));
    }

    @Override
    protected boolean includeRefAllele() {
        return true;
    }

    @Override
    protected String getVcfKey() {
        return "MMQ";
    }

    @Override
    protected String getDescription() {
        return "median mapping quality";
    }

    @Override
    protected OptionalInt getValueForRead(GATKRead read, VariantContext vc) {
        Utils.nonNull(read);
        return OptionalInt.of(read.getMappingQuality());
    }
}

