/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Count of all reads with MAPQ = 0 across all samples (MQ0)")
public final class MappingQualityZero
extends InfoFieldAnnotation {
    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (!vc.isVariant() || likelihoods == null) {
            return Collections.emptyMap();
        }
        long mq0 = IntStream.range(0, likelihoods.numberOfSamples()).boxed().flatMap(s -> likelihoods.sampleEvidence((int)s).stream()).filter(r -> r.getMappingQuality() == 0).count();
        return Collections.singletonMap(this.getKeyNames().get(0), MappingQualityZero.formattedValue(mq0));
    }

    @VisibleForTesting
    static String formattedValue(long mq0) {
        return String.format("%d", mq0);
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("MQ0");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Collections.singletonList(VCFStandardHeaderLines.getInfoLine((String)this.getKeyNames().get(0)));
    }
}

