/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.BaseQualityRankSumTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.GenotypeAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardMutectAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Count of read pairs in the F1R2 and F2R1 configurations supporting REF and ALT alleles (F1R2, F2R1)")
public final class OrientationBiasReadCounts
extends GenotypeAnnotation
implements StandardMutectAnnotation {
    private static final Logger logger = LogManager.getLogger(OrientationBiasReadCounts.class);
    private static final int MINIMUM_BASE_QUALITY = 20;

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("F1R2", "F2R1");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Arrays.asList(GATKVCFHeaderLines.getFormatLine("F1R2"), GATKVCFHeaderLines.getFormatLine("F2R1"));
    }

    @Override
    public void annotate(ReferenceContext refContext, VariantContext vc, Genotype g, GenotypeBuilder gb, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(gb, "gb is null");
        Utils.nonNull(vc, "vc is null");
        if (g == null || likelihoods == null) {
            return;
        }
        Map<Allele, MutableInt> f1r2Counts = likelihoods.alleles().stream().collect(Collectors.toMap(a -> a, a -> new MutableInt(0)));
        Map<Allele, MutableInt> f2r1Counts = likelihoods.alleles().stream().collect(Collectors.toMap(a -> a, a -> new MutableInt(0)));
        Utils.stream(likelihoods.bestAllelesBreakingTies(g.getSampleName())).filter(ba -> ba.isInformative() && OrientationBiasReadCounts.isUsableRead((GATKRead)ba.evidence) && BaseQualityRankSumTest.getReadBaseQuality((GATKRead)ba.evidence, vc).orElse(0.0) >= 20.0).forEach(ba -> ((MutableInt)(ReadUtils.isF2R1((GATKRead)ba.evidence) ? f2r1Counts : f1r2Counts).get(ba.allele)).increment());
        int[] f1r2 = vc.getAlleles().stream().mapToInt(a -> ((MutableInt)f1r2Counts.get(a)).intValue()).toArray();
        int[] f2r1 = vc.getAlleles().stream().mapToInt(a -> ((MutableInt)f2r1Counts.get(a)).intValue()).toArray();
        gb.attribute("F1R2", (Object)f1r2);
        gb.attribute("F2R1", (Object)f2r1);
    }

    public static void annotateSingleVariant(VariantContext vc, GenotypeBuilder gb, ReadPileup readPileup, int meanBaseQualityCutoff) {
        Utils.nonNull(gb, "gb is null");
        Utils.nonNull(vc, "vc is null");
        List variantAllelesWithDupes = vc.getAlleles();
        LinkedHashSet alleleSet = new LinkedHashSet(variantAllelesWithDupes);
        ArrayList variantAlleles = new ArrayList(alleleSet);
        Map f1r2Counts = variantAlleles.stream().collect(Collectors.toMap(Function.identity(), a -> new MutableInt(0)));
        Map f2r1Counts = variantAlleles.stream().collect(Collectors.toMap(Function.identity(), a -> new MutableInt(0)));
        List referenceAlleles = variantAlleles.stream().filter(a -> a.isReference() && !a.isSymbolic()).collect(Collectors.toList());
        List altAlleles = variantAlleles.stream().filter(a -> a.isNonReference() && !a.isSymbolic()).collect(Collectors.toList());
        if (referenceAlleles.size() != 1) {
            logger.warn("Number of reference alleles does not equal  for VC: " + vc);
        }
        if (referenceAlleles.size() == 1 && readPileup != null && !((Allele)referenceAlleles.get(0)).isSymbolic()) {
            Allele referenceAllele = (Allele)referenceAlleles.get(0);
            Utils.stream(readPileup).filter(pe -> OrientationBiasReadCounts.isUsableRead(pe.getRead())).forEach(pe -> OrientationBiasReadCounts.incrementCounts(pe, f1r2Counts, f2r1Counts, referenceAllele, altAlleles, meanBaseQualityCutoff));
        }
        int[] f1r2 = variantAlleles.stream().mapToInt(a -> ((MutableInt)f1r2Counts.get(a)).intValue()).toArray();
        int[] f2r1 = variantAlleles.stream().mapToInt(a -> ((MutableInt)f2r1Counts.get(a)).intValue()).toArray();
        gb.attribute("F1R2", (Object)f1r2);
        gb.attribute("F2R1", (Object)f2r1);
    }

    private static void incrementCounts(PileupElement pileupElement, Map<Allele, MutableInt> f1r2Counts, Map<Allele, MutableInt> f2r1Counts, Allele referenceAllele, List<Allele> altAlleles, int minBaseQualityCutoff) {
        Map<Allele, MutableInt> countMap = ReadUtils.isF2R1(pileupElement.getRead()) ? f2r1Counts : f1r2Counts;
        Allele pileupAllele = GATKVariantContextUtils.chooseAlleleForRead(pileupElement, referenceAllele, altAlleles, minBaseQualityCutoff);
        if (pileupAllele == null) {
            return;
        }
        if (countMap.containsKey(pileupAllele)) {
            countMap.get(pileupAllele).increment();
        }
    }

    protected static boolean isUsableRead(GATKRead read) {
        return read.getMappingQuality() != 0 && read.getMappingQuality() != 255;
    }
}

