/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.collect.ImmutableMap;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.AddOriginalAlignmentTags;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.mutect.filtering.Mutect2FilteringEngine;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Number of alt reads with an OA tag that doesn't match the current alignment contig.")
public class OriginalAlignment
extends InfoFieldAnnotation {
    protected final OneShotLogger warning = new OneShotLogger(this.getClass());
    public static final String KEY = "OCM";

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        Utils.nonNull(likelihoods);
        double[] lods = Mutect2FilteringEngine.getTumorLogOdds(vc);
        if (lods == null) {
            this.warning.warn(String.format("One or more variant contexts is missing the 'TLOD' annotation, %s will not be computed for these VariantContexts", KEY));
            return Collections.emptyMap();
        }
        int indexOfMaxLod = MathUtils.maxElementIndex(lods);
        Allele altAlelle = vc.getAlternateAllele(indexOfMaxLod);
        Collection<AlleleLikelihoods.BestAllele> bestAlleles = likelihoods.bestAllelesBreakingTies();
        String currentContig = ref.getInterval().getContig();
        long nonChrMAlt = bestAlleles.stream().filter(ba -> ((GATKRead)ba.evidence).hasAttribute("OA") && ba.isInformative() && ba.allele.equals((Object)altAlelle) && !AddOriginalAlignmentTags.getOAContig((GATKRead)ba.evidence).equals(currentContig)).count();
        return ImmutableMap.of((Object)KEY, (Object)nonChrMAlt);
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Collections.singletonList(GATKVCFHeaderLines.getInfoLine(KEY));
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList(KEY);
    }
}

