/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.utils.samples.PedigreeValidationType;
import org.broadinstitute.hellbender.utils.samples.SampleDBBuilder;
import org.broadinstitute.hellbender.utils.samples.Trio;

public abstract class PedigreeAnnotation
extends InfoFieldAnnotation {
    private Collection<String> founderIds;
    private GATKPath pedigreeFile = null;
    private boolean hasAddedPedigreeFounders = false;
    protected final transient Logger logger = LogManager.getLogger(this.getClass());

    protected GenotypesContext getFounderGenotypes(VariantContext vc) {
        if (this.pedigreeFile != null && !this.hasAddedPedigreeFounders) {
            this.initializeSampleDBAndSetFounders(this.pedigreeFile);
        }
        return this.founderIds == null || this.founderIds.isEmpty() ? vc.getGenotypes() : vc.getGenotypes(new HashSet<String>(this.founderIds));
    }

    public PedigreeAnnotation(Set<String> founderIds) {
        this.founderIds = founderIds == null ? new ArrayList<String>() : new ArrayList<String>(founderIds);
    }

    public PedigreeAnnotation(GATKPath pedigreeFile) {
        this.pedigreeFile = pedigreeFile;
        this.initializeSampleDBAndSetFounders(pedigreeFile);
    }

    private void initializeSampleDBAndSetFounders(GATKPath pedigreeFile) {
        SampleDBBuilder sampleDBBuilder = new SampleDBBuilder(PedigreeValidationType.STRICT);
        sampleDBBuilder.addSamplesFromPedigreeFiles(Collections.singletonList(pedigreeFile));
        Set<String> founderIdsToAdd = sampleDBBuilder.getFinalSampleDB().getFounderIds();
        if (this.founderIds == null || this.founderIds.isEmpty()) {
            this.founderIds = founderIdsToAdd;
        } else {
            this.founderIds.addAll(founderIdsToAdd);
        }
        this.hasAddedPedigreeFounders = true;
    }

    protected Set<Trio> getTrios() {
        if (this.pedigreeFile != null) {
            SampleDBBuilder sampleDBBuilder = new SampleDBBuilder(PedigreeValidationType.STRICT);
            sampleDBBuilder.addSamplesFromPedigreeFiles(Collections.singletonList(this.pedigreeFile));
            return sampleDBBuilder.getFinalSampleDB().getTrios();
        }
        return Collections.emptySet();
    }

    public void setPedigreeFile(GATKPath pedigreeFile) {
        this.pedigreeFile = pedigreeFile;
        this.hasAddedPedigreeFounders = false;
    }

    public void setFounderIds(List<String> founderIds) {
        this.founderIds = founderIds;
        this.hasAddedPedigreeFounders = false;
    }

    public void validateArguments() {
        this.validateArguments(this.founderIds, this.pedigreeFile);
    }

    void validateArguments(Collection<String> founderIds, GATKPath pedigreeFile) {
        if ((founderIds == null || founderIds.isEmpty()) && pedigreeFile == null) {
            this.logger.warn(this.getClass().getSimpleName() + " annotation will not be calculated, no 'founder-id' or 'pedigree' arguments provided");
        }
    }
}

