/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.collect.ImmutableMap;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class PerAlleleAnnotation
extends InfoFieldAnnotation {
    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (likelihoods == null) {
            return Collections.emptyMap();
        }
        Map<Allele, List> values = likelihoods.alleles().stream().collect(Collectors.toMap(a -> a, a -> new ArrayList()));
        Utils.stream(likelihoods.bestAllelesBreakingTies()).filter(ba -> ba.isInformative() && PerAlleleAnnotation.isUsableRead((GATKRead)ba.evidence)).forEach(ba -> this.getValueForRead((GATKRead)ba.evidence, vc).ifPresent(v -> ((List)values.get(ba.allele)).add(v)));
        int[] statistics = vc.getAlleles().stream().filter(this::includeAllele).mapToInt(a -> this.aggregate((List)values.get(a))).toArray();
        return ImmutableMap.of((Object)this.getVcfKey(), (Object)statistics);
    }

    private boolean includeAllele(Allele allele) {
        return allele.isNonReference() || this.includeRefAllele();
    }

    protected boolean includeRefAllele() {
        return false;
    }

    private static boolean isUsableRead(GATKRead read) {
        return read.getMappingQuality() != 0 && read.getMappingQuality() != 255;
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(this.getVcfKey(), this.includeRefAllele() ? VCFHeaderLineCount.R : VCFHeaderLineCount.A, VCFHeaderLineType.Integer, this.getDescription()));
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList(this.getVcfKey());
    }

    protected abstract OptionalInt getValueForRead(GATKRead var1, VariantContext var2);

    protected abstract int aggregate(List<Integer> var1);

    protected abstract String getVcfKey();

    protected abstract String getDescription();
}

