/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.PedigreeAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.samples.MendelianViolation;
import org.broadinstitute.hellbender.utils.samples.Trio;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Existence of a de novo mutation in at least one of the given families (hiConfDeNovo, loConfDeNovo)")
public final class PossibleDeNovo
extends PedigreeAnnotation {
    protected final Logger warning = LogManager.getLogger(this.getClass());
    private final MendelianViolation mendelianViolation;
    private Set<Trio> trios;
    public static final double DEFAULT_MIN_GENOTYPE_QUALITY_P = 0.0;
    private static final int hi_GQ_threshold = 20;
    private static final int lo_GQ_threshold = 10;
    private static final double percentOfSamplesCutoff = 0.001;
    private static final int flatNumberOfSamplesCutoff = 4;

    @VisibleForTesting
    public PossibleDeNovo(Set<Trio> trios, double minGenotypeQualityP) {
        super((Set<String>)null);
        this.trios = Collections.unmodifiableSet(new LinkedHashSet<Trio>(trios));
        this.mendelianViolation = new MendelianViolation(minGenotypeQualityP);
    }

    public PossibleDeNovo(GATKPath pedigreeFile) {
        super(pedigreeFile);
        this.mendelianViolation = new MendelianViolation(0.0);
    }

    public PossibleDeNovo() {
        super((Set<String>)null);
        this.mendelianViolation = new MendelianViolation(0.0);
    }

    @Override
    void validateArguments(Collection<String> founderIds, GATKPath pedigreeFile) {
        if (pedigreeFile == null) {
            if (founderIds != null && !founderIds.isEmpty()) {
                this.warning.warn("PossibleDenovo annotation will not be calculated, must provide a valid PED file (-ped). Founder-id arguments cannot be used for this annotation");
            } else {
                this.warning.warn("PossibleDenovo Annotation will not be calculated, must provide a valid PED file (-ped) from the command line.");
            }
        } else if (founderIds != null && !founderIds.isEmpty()) {
            this.warning.warn("PossibleDenovo annotation does not take founder-id arguments, trio information will be extracted only from the provided PED file");
        }
    }

    private Set<Trio> initializeAndGetTrios() {
        if (this.trios == null) {
            this.trios = this.getTrios();
        }
        return this.trios;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("hiConfDeNovo", "loConfDeNovo");
    }

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        Set<Trio> trioSet = this.initializeAndGetTrios();
        if (trioSet.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<String> highConfDeNovoChildren = new ArrayList<String>();
        ArrayList<String> lowConfDeNovoChildren = new ArrayList<String>();
        for (Trio trio : trioSet) {
            if (!vc.isBiallelic() || !PossibleDeNovo.contextHasTrioLikelihoods(vc, trio) || !this.mendelianViolation.isViolation(trio.getMother(), trio.getFather(), trio.getChild(), vc) || this.mendelianViolation.getParentsRefRefChildHet() <= 0) continue;
            int childGQ = vc.getGenotype(trio.getChildID()).getGQ();
            int momGQ = vc.getGenotype(trio.getMaternalID()).getGQ();
            int dadGQ = vc.getGenotype(trio.getPaternalID()).getGQ();
            if (childGQ >= 20 && momGQ >= 20 && dadGQ >= 20) {
                highConfDeNovoChildren.add(trio.getChildID());
                continue;
            }
            if (childGQ < 10 || momGQ <= 0 || dadGQ <= 0) continue;
            lowConfDeNovoChildren.add(trio.getChildID());
        }
        double percentNumberOfSamplesCutoff = (double)vc.getNSamples() * 0.001;
        double AFcutoff = Math.max(4.0, percentNumberOfSamplesCutoff);
        int deNovoAlleleCount = vc.getCalledChrCount(vc.getAlternateAllele(0));
        LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>(2);
        if (!highConfDeNovoChildren.isEmpty() && (double)deNovoAlleleCount < AFcutoff) {
            attributeMap.put("hiConfDeNovo", highConfDeNovoChildren);
        }
        if (!lowConfDeNovoChildren.isEmpty() && (double)deNovoAlleleCount < AFcutoff) {
            attributeMap.put("loConfDeNovo", lowConfDeNovoChildren);
        }
        return attributeMap;
    }

    private static boolean contextHasTrioLikelihoods(VariantContext vc, Trio trio) {
        String mom = trio.getMaternalID();
        String dad = trio.getPaternalID();
        String kid = trio.getChildID();
        return !mom.isEmpty() && vc.hasGenotype(mom) && vc.getGenotype(mom).hasLikelihoods() && !dad.isEmpty() && vc.hasGenotype(dad) && vc.getGenotype(dad).hasLikelihoods() && !kid.isEmpty() && vc.hasGenotype(kid) && vc.getGenotype(kid).hasLikelihoods();
    }
}

