/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Variant confidence normalized by unfiltered depth of variant samples (QD)")
public final class QualByDepth
extends InfoFieldAnnotation
implements StandardAnnotation {
    @VisibleForTesting
    static final double MAX_QD_BEFORE_FIXING = 35.0;
    @VisibleForTesting
    static final double IDEAL_HIGH_QD = 30.0;
    private static final double JITTER_SIGMA = 3.0;

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (!vc.hasLog10PError()) {
            return Collections.emptyMap();
        }
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.isEmpty()) {
            return Collections.emptyMap();
        }
        int depth = QualByDepth.getDepth(genotypes, likelihoods);
        if (depth == 0) {
            return Collections.emptyMap();
        }
        double qual = -10.0 * vc.getLog10PError();
        double QD = qual / (double)depth;
        QD = QualByDepth.fixTooHighQD(QD);
        return Collections.singletonMap(this.getKeyNames().get(0), String.format("%.2f", QD));
    }

    public static double fixTooHighQD(double QD) {
        if (QD < 35.0) {
            return QD;
        }
        return 30.0 + Utils.getRandomGenerator().nextGaussian() * 3.0;
    }

    public static int getDepth(GenotypesContext genotypes, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        int depth = 0;
        int ADrestrictedDepth = 0;
        for (Genotype genotype : genotypes) {
            int[] AD;
            int totalADdepth;
            if (!genotype.isHet() && !genotype.isHomVar()) continue;
            if (genotype.hasAD() && (totalADdepth = (int)MathUtils.sum(AD = genotype.getAD())) != 0) {
                if (totalADdepth - AD[0] > 1) {
                    ADrestrictedDepth += totalADdepth;
                }
                depth += totalADdepth;
                continue;
            }
            if (likelihoods != null) {
                depth += likelihoods.sampleEvidenceCount(likelihoods.indexOfSample(genotype.getSampleName()));
                continue;
            }
            if (!genotype.hasDP()) continue;
            depth += genotype.getDP();
        }
        if (ADrestrictedDepth > 0) {
            depth = ADrestrictedDepth;
        }
        return depth;
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("QD");
    }
}

