/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotationData;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVCFConstants;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;
import org.broadinstitute.hellbender.utils.variant.VariantContextGetters;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Root mean square of the mapping quality of reads across all samples (MQ)")
public final class RMSMappingQuality
extends InfoFieldAnnotation
implements StandardAnnotation,
ReducibleAnnotation {
    private static final OneShotLogger logger = new OneShotLogger(RMSMappingQuality.class);
    private static final RMSMappingQuality instance = new RMSMappingQuality();
    private static final int NUM_LIST_ENTRIES = 2;
    private static final int SUM_OF_SQUARES_INDEX = 0;
    private static final int TOTAL_DEPTH_INDEX = 1;
    private static final String OUTPUT_PRECISION = "%.2f";
    public static final String RMS_MAPPING_QUALITY_OLD_BEHAVIOR_OVERRIDE_ARGUMENT = "allow-old-rms-mapping-quality-annotation-data";
    @Argument(fullName="allow-old-rms-mapping-quality-annotation-data", doc="Override to allow old RMSMappingQuality annotated VCFs to function", optional=true)
    public boolean allowOlderRawKeyValues = false;

    @Override
    public String getPrimaryRawKey() {
        return "RAW_MQandDP";
    }

    @Override
    public boolean hasSecondaryRawKeys() {
        return false;
    }

    @Override
    public List<String> getSecondaryRawKeys() {
        return null;
    }

    public static String getDeprecatedRawKeyName() {
        return "RAW_MQ";
    }

    @Override
    public List<String> getKeyNames() {
        ArrayList<String> allKeys = new ArrayList<String>();
        allKeys.add("MQ");
        allKeys.addAll(this.getRawKeyNames());
        return allKeys;
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(VCFStandardHeaderLines.getInfoLine((String)this.getKeyNames().get(0)));
    }

    @Override
    public List<VCFInfoHeaderLine> getRawDescriptions() {
        ArrayList<VCFInfoHeaderLine> lines = new ArrayList<VCFInfoHeaderLine>(1);
        for (String rawKey : this.getRawKeyNames()) {
            lines.add(GATKVCFHeaderLines.getInfoLine(rawKey));
        }
        return lines;
    }

    @Override
    public Map<String, Object> annotateRawData(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (likelihoods == null || likelihoods.evidenceCount() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        ReducibleAnnotationData myData = new ReducibleAnnotationData(null);
        this.calculateRawData(vc, likelihoods, myData);
        String annotationString = this.makeRawAnnotationString(vc.getAlleles(), myData.getAttributeMap());
        annotations.put(this.getPrimaryRawKey(), annotationString);
        return annotations;
    }

    @Override
    public Map<String, Object> combineRawData(List<Allele> vcAlleles, List<ReducibleAnnotationData<?>> annotationList) {
        ReducibleAnnotationData<List<Long>> combinedData = new ReducibleAnnotationData<List<Long>>(null);
        for (ReducibleAnnotationData<List<Long>> reducibleAnnotationData : annotationList) {
            this.parseRawDataString(reducibleAnnotationData);
            this.combineAttributeMap(reducibleAnnotationData, combinedData);
        }
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        String string = this.makeRawAnnotationString(vcAlleles, combinedData.getAttributeMap());
        annotations.put(this.getPrimaryRawKey(), string);
        return annotations;
    }

    private String makeRawAnnotationString(List<Allele> vcAlleles, Map<Allele, List<Long>> perAlleleData) {
        return String.format("%d,%d", perAlleleData.get(Allele.NO_CALL).get(0), perAlleleData.get(Allele.NO_CALL).get(1));
    }

    @Override
    public Map<String, Object> finalizeRawData(VariantContext vc, VariantContext originalVC) {
        String rawMQdata;
        if (vc.hasAttribute(this.getPrimaryRawKey())) {
            rawMQdata = vc.getAttributeAsString(this.getPrimaryRawKey(), null);
        } else if (vc.hasAttribute(RMSMappingQuality.getDeprecatedRawKeyName())) {
            if (!this.allowOlderRawKeyValues) {
                throw new UserException.BadInput("Presence of '-" + RMSMappingQuality.getDeprecatedRawKeyName() + "' annotation is detected. This GATK version expects key " + this.getPrimaryRawKey() + " with a tuple of sum of squared MQ values and total reads over variant genotypes as the value. This could indicate that the provided input was produced with an older version of GATK. Use the argument '--" + RMS_MAPPING_QUALITY_OLD_BEHAVIOR_OVERRIDE_ARGUMENT + "' to override and attempt the deprecated MQ calculation. There may be differences in how newer GATK versions calculate DP and MQ that may result in worse MQ results. Use at your own risk.");
            }
            rawMQdata = vc.getAttributeAsString(RMSMappingQuality.getDeprecatedRawKeyName(), null);
            if (vc.hasAttribute("MQ_DP")) {
                logger.warn("Presence of MQ_DP key indicates that this tool may be running on an older output of ReblockGVCF that may not have compatible annotations with this GATK version. Attempting to reformat MQ data.");
                String rawMQdepth = vc.getAttributeAsString("MQ_DP", null);
                if (rawMQdepth == null) {
                    throw new UserException.BadInput("MQ annotation data is not properly formatted. This version expects a long tuple of sum of squared MQ values and total reads over variant genotypes.");
                }
                rawMQdata = Math.round(Double.parseDouble(rawMQdata)) + "," + rawMQdepth;
            } else {
                logger.warn("MQ annotation data is not properly formatted. This GATK version expects key " + this.getPrimaryRawKey() + " with a tuple of sum of squared MQ values and total reads over variant genotypes as the value. Attempting to use deprecated MQ calculation.");
                long numOfReads = RMSMappingQuality.getNumOfReads(vc, null);
                rawMQdata = Math.round(Double.parseDouble(rawMQdata)) + "," + numOfReads;
            }
        } else {
            return new HashMap<String, Object>();
        }
        if (rawMQdata == null) {
            return new HashMap<String, Object>();
        }
        ReducibleAnnotationData<List<Long>> myData = new ReducibleAnnotationData<List<Long>>(rawMQdata);
        this.parseRawDataString(myData);
        String annotationString = this.makeFinalizedAnnotationString(myData.getAttribute(Allele.NO_CALL).get(1), myData.getAttribute(Allele.NO_CALL).get(0));
        return Collections.singletonMap(this.getKeyNames().get(0), annotationString);
    }

    private String makeFinalizedAnnotationString(long numOfReads, long sumOfSquaredMQs) {
        return String.format(OUTPUT_PRECISION, Math.sqrt((double)sumOfSquaredMQs / (double)numOfReads));
    }

    private void combineAttributeMap(ReducibleAnnotationData<List<Long>> toAdd, ReducibleAnnotationData<List<Long>> combined) {
        if (combined.getAttribute(Allele.NO_CALL) != null) {
            combined.putAttribute(Allele.NO_CALL, Arrays.asList(combined.getAttribute(Allele.NO_CALL).get(0) + toAdd.getAttribute(Allele.NO_CALL).get(0), combined.getAttribute(Allele.NO_CALL).get(1) + toAdd.getAttribute(Allele.NO_CALL).get(1)));
        } else {
            combined.putAttribute(Allele.NO_CALL, toAdd.getAttribute(Allele.NO_CALL));
        }
    }

    private void calculateRawData(VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods, ReducibleAnnotationData rawAnnotations) {
        long squareSum = 0L;
        long numReadsUsed = 0L;
        for (int i = 0; i < likelihoods.numberOfSamples(); ++i) {
            for (GATKRead read : likelihoods.sampleEvidence(i)) {
                long mq = read.getMappingQuality();
                if (mq == 255L) continue;
                squareSum += mq * mq;
                ++numReadsUsed;
            }
        }
        rawAnnotations.putAttribute(Allele.NO_CALL, Arrays.asList(squareSum, numReadsUsed));
    }

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (likelihoods == null || likelihoods.evidenceCount() < 1) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> annotations = new HashMap<String, Object>();
        ReducibleAnnotationData myData = new ReducibleAnnotationData(null);
        this.calculateRawData(vc, likelihoods, myData);
        String annotationString = this.makeFinalizedAnnotationString((Long)((List)myData.getAttribute(Allele.NO_CALL)).get(1), (Long)((List)myData.getAttribute(Allele.NO_CALL)).get(0));
        annotations.put(this.getKeyNames().get(0), annotationString);
        return annotations;
    }

    @VisibleForTesting
    static String formattedValue(double rms) {
        return String.format(OUTPUT_PRECISION, rms);
    }

    public VariantContext finalizeRawMQ(VariantContext vc) {
        String rawMQdata = vc.getAttributeAsString(this.getPrimaryRawKey(), null);
        if (rawMQdata == null) {
            if (!vc.hasAttribute("MQ_DP")) {
                return vc;
            }
            if (vc.hasAttribute("MQ_DP")) {
                int numOfReads = vc.getAttributeAsInt("MQ_DP", RMSMappingQuality.getNumOfReads(vc));
                String deprecatedRawMQdata = vc.getAttributeAsString(RMSMappingQuality.getDeprecatedRawKeyName(), null);
                double squareSum = RMSMappingQuality.parseDeprecatedRawDataString(deprecatedRawMQdata);
                double rms = Math.sqrt(squareSum / (double)numOfReads);
                String finalizedRMSMAppingQuality = RMSMappingQuality.formattedValue(rms);
                return new VariantContextBuilder(vc).rmAttribute(RMSMappingQuality.getDeprecatedRawKeyName()).rmAttributes(this.getRawKeyNames()).attribute(this.getKeyNames().get(0), (Object)finalizedRMSMAppingQuality).make();
            }
        } else {
            List<Long> SSQMQandDP = RMSMappingQuality.parseRawDataString(rawMQdata);
            double rms = Math.sqrt((double)SSQMQandDP.get(0).longValue() / (double)SSQMQandDP.get(1).longValue());
            String finalizedRMSMAppingQuality = RMSMappingQuality.formattedValue(rms);
            return new VariantContextBuilder(vc).rmAttribute(RMSMappingQuality.getDeprecatedRawKeyName()).rmAttributes(this.getRawKeyNames()).attribute(this.getKeyNames().get(0), (Object)finalizedRMSMAppingQuality).make();
        }
        return vc;
    }

    private void parseRawDataString(ReducibleAnnotationData<List<Long>> myData) {
        myData.putAttribute(Allele.NO_CALL, RMSMappingQuality.parseRawDataString(myData.getRawData()));
    }

    private static List<Long> parseRawDataString(String rawDataString) {
        try {
            String[] parsed = rawDataString.trim().replaceAll("\\[|\\]", "").split(", *");
            if (parsed.length != 2) {
                throw new UserException.BadInput("Raw value for annotation has " + parsed.length + " values, expected " + 2);
            }
            long squareSum = Long.parseLong(parsed[0]);
            long totalDP = Long.parseLong(parsed[1]);
            return Arrays.asList(squareSum, totalDP);
        }
        catch (NumberFormatException e) {
            throw new UserException.BadInput("malformed RAW_MQandDP annotation: " + rawDataString);
        }
    }

    private static double parseDeprecatedRawDataString(String rawDataString) {
        try {
            double squareSum = Double.parseDouble(rawDataString.split(",")[0]);
            return squareSum;
        }
        catch (NumberFormatException e) {
            throw new UserException.BadInput("malformed " + RMSMappingQuality.getDeprecatedRawKeyName() + " annotation: " + rawDataString);
        }
    }

    @VisibleForTesting
    private static int getNumOfReads(VariantContext vc) {
        int mqDP;
        if (vc.hasAttribute("MQ_DP") && (mqDP = vc.getAttributeAsInt("MQ_DP", 0)) > 0) {
            return mqDP;
        }
        int numOfReads = vc.getAttributeAsInt("DP", -1);
        if (vc.hasGenotypes()) {
            for (Genotype gt : vc.getGenotypes()) {
                if (RMSMappingQuality.hasReferenceDepth(gt)) {
                    if (gt.hasExtendedAttribute("MIN_DP")) {
                        numOfReads -= Integer.parseInt(gt.getExtendedAttribute("MIN_DP").toString());
                        continue;
                    }
                    if (!gt.hasDP()) continue;
                    numOfReads -= gt.getDP();
                    continue;
                }
                if (!RMSMappingQuality.hasSpanningDeletionAllele(gt)) continue;
                if (gt.hasExtendedAttribute("MIN_DP")) {
                    numOfReads -= Integer.parseInt(gt.getExtendedAttribute("MIN_DP").toString());
                    continue;
                }
                if (!gt.hasDP()) continue;
                numOfReads -= gt.getDP();
            }
        }
        if (numOfReads <= 0) {
            numOfReads = -1;
        }
        return numOfReads;
    }

    private static boolean hasReferenceDepth(Genotype gt) {
        return gt.isHomRef() || gt.isNoCall() && gt.hasPL() && gt.getPL()[0] == 0 && gt.getPL()[1] != 0;
    }

    @VisibleForTesting
    static long getNumOfReads(VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        List<Long> mqTuple;
        if (vc.hasAttribute("RAW_MQandDP") && (mqTuple = VariantContextGetters.getAttributeAsLongList(vc, "RAW_MQandDP", 0L)).get(1) > 0L) {
            return mqTuple.get(1);
        }
        long numOfReads = 0L;
        if (vc.hasAttribute("DP")) {
            numOfReads = VariantContextGetters.getAttributeAsLong(vc, "DP", -1L);
            if (vc.hasGenotypes()) {
                for (Genotype gt : vc.getGenotypes()) {
                    if (!gt.isHomRef()) continue;
                    if (gt.hasExtendedAttribute("MIN_DP")) {
                        numOfReads -= Long.parseLong(gt.getExtendedAttribute("MIN_DP").toString());
                        continue;
                    }
                    if (!gt.hasDP()) continue;
                    numOfReads -= (long)gt.getDP();
                }
            }
        } else if (likelihoods != null && likelihoods.numberOfAlleles() != 0) {
            for (int i = 0; i < likelihoods.numberOfSamples(); ++i) {
                for (GATKRead read : likelihoods.sampleEvidence(i)) {
                    if (read.getMappingQuality() == 255) continue;
                    ++numOfReads;
                }
            }
        }
        if (numOfReads <= 0L) {
            numOfReads = -1L;
        }
        return numOfReads;
    }

    private static boolean hasSpanningDeletionAllele(Genotype gt) {
        for (Allele a : gt.getAlleles()) {
            boolean hasSpanningDeletion = GATKVCFConstants.isSpanningDeletion(a);
            if (!hasSpanningDeletion) continue;
            return true;
        }
        return false;
    }

    public static RMSMappingQuality getInstance() {
        return instance;
    }
}

