/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.primitives.Doubles;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.utils.MannWhitneyU;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class RankSumTest
extends InfoFieldAnnotation
implements Annotation {
    protected static final double INVALID_ELEMENT_FROM_READ = Double.NEGATIVE_INFINITY;

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc, "vc is null");
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<Double> refQuals = new ArrayList<Double>();
        ArrayList<Double> altQuals = new ArrayList<Double>();
        if (likelihoods != null) {
            this.fillQualsFromLikelihood(vc, likelihoods, refQuals, altQuals);
        }
        if (refQuals.isEmpty() && altQuals.isEmpty()) {
            return Collections.emptyMap();
        }
        MannWhitneyU mannWhitneyU = new MannWhitneyU();
        MannWhitneyU.Result result = mannWhitneyU.test(Doubles.toArray(altQuals), Doubles.toArray(refQuals), MannWhitneyU.TestType.FIRST_DOMINATES);
        double zScore = result.getZ();
        if (Double.isNaN(zScore)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.getKeyNames().get(0), String.format("%.3f", zScore));
    }

    protected void fillQualsFromLikelihood(VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods, List<Double> refQuals, List<Double> altQuals) {
        for (AlleleLikelihoods.BestAllele bestAllele : likelihoods.bestAllelesBreakingTies()) {
            OptionalDouble value;
            GATKRead read = (GATKRead)bestAllele.evidence;
            Object allele = bestAllele.allele;
            if (!bestAllele.isInformative() || !this.isUsableRead(read, vc) || !(value = this.getElementForRead(read, vc, bestAllele)).isPresent() || value.getAsDouble() == Double.NEGATIVE_INFINITY) continue;
            if (allele.isReference()) {
                refQuals.add(value.getAsDouble());
                continue;
            }
            if (!vc.hasAllele(allele)) continue;
            altQuals.add(value.getAsDouble());
        }
    }

    protected OptionalDouble getElementForRead(GATKRead read, VariantContext vc, AlleleLikelihoods.BestAllele bestAllele) {
        return this.getElementForRead(read, vc);
    }

    protected abstract OptionalDouble getElementForRead(GATKRead var1, VariantContext var2);

    protected boolean isUsableRead(GATKRead read, VariantContext vc) {
        Utils.nonNull(read);
        return read.getMappingQuality() != 0 && read.getMappingQuality() != 255;
    }
}

