/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.OptionalDouble;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.tools.walkers.annotator.RankSumTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Rank sum test for relative positioning of REF versus ALT alleles within reads (ReadPosRankSum)")
public final class ReadPosRankSumTest
extends RankSumTest
implements StandardAnnotation {
    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("ReadPosRankSum");
    }

    @Override
    protected OptionalDouble getElementForRead(GATKRead read, VariantContext vc) {
        return ReadPosRankSumTest.getReadPosition(read, vc);
    }

    @Override
    public boolean isUsableRead(GATKRead read, VariantContext vc) {
        Utils.nonNull(read);
        return super.isUsableRead(read, vc) && read.getSoftStart() <= vc.getEnd() + 1 && read.getSoftEnd() >= vc.getStart();
    }

    public static OptionalDouble getReadPosition(GATKRead read, VariantContext vc) {
        Utils.nonNull(read);
        if (read.getStart() == vc.getEnd() + 1 && read.getCigarElements().stream().map(CigarElement::getOperator).filter(o -> !o.isClipping()).findFirst().orElse(null) == CigarOperator.INSERTION) {
            return OptionalDouble.of(0.0);
        }
        Pair<Integer, CigarOperator> offset = ReadUtils.getReadIndexForReferenceCoordinate(read, vc.getStart());
        if ((Integer)offset.getLeft() == -1) {
            return OptionalDouble.empty();
        }
        Cigar cigar = read.getCigar();
        CigarElement firstElement = cigar.getFirstCigarElement();
        CigarElement lastElement = cigar.getLastCigarElement();
        int leadingHardClips = firstElement.getOperator() == CigarOperator.HARD_CLIP ? firstElement.getLength() : 0;
        int trailingHardClips = lastElement.getOperator() == CigarOperator.HARD_CLIP ? lastElement.getLength() : 0;
        int leftDistance = leadingHardClips + (Integer)offset.getLeft();
        int rightDistance = read.getLength() - 1 - (Integer)offset.getLeft() + trailingHardClips;
        return OptionalDouble.of(Math.min(leftDistance, rightDistance));
    }
}

