/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.primitives.Ints;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.tools.walkers.annotator.PerAlleleAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.ReadPosRankSumTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardMutectAnnotation;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Median distance of variant starts from ends of reads supporting each allele (MPOS)")
public class ReadPosition
extends PerAlleleAnnotation
implements StandardMutectAnnotation {
    private static final int VALUE_FOR_NO_READS = 50;

    @Override
    protected int aggregate(List<Integer> values) {
        return values.isEmpty() ? 50 : MathUtils.median(Ints.toArray(values));
    }

    @Override
    protected String getVcfKey() {
        return "MPOS";
    }

    @Override
    protected String getDescription() {
        return "median distance from end of read";
    }

    @Override
    protected OptionalInt getValueForRead(GATKRead read, VariantContext vc) {
        if (vc.getStart() < read.getStart() || read.getEnd() < vc.getStart()) {
            return OptionalInt.empty();
        }
        OptionalDouble valueAsDouble = ReadPosRankSumTest.getReadPosition(read, vc);
        return valueAsDouble.isPresent() ? OptionalInt.of((int)valueAsDouble.getAsDouble()) : OptionalInt.empty();
    }
}

