/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.logging.OneShotLogger;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Annotate with local reference bases (REF_BASES)")
public class ReferenceBases
extends InfoFieldAnnotation {
    public static final String REFERENCE_BASES_KEY = "REF_BASES";
    private int NUM_BASES_ON_EITHER_SIDE = 10;
    private int REFERENCE_CONTEXT_LENGTH = 2 * this.NUM_BASES_ON_EITHER_SIDE + 1;
    protected final OneShotLogger warning = new OneShotLogger(this.getClass());

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList(REFERENCE_BASES_KEY);
    }

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        int endIndex;
        if (ref == null) {
            this.warning.warn("REF_BASES requires the reference to annotate, none was provided");
            return Collections.emptyMap();
        }
        int basesToDiscardInFront = Math.max(vc.getStart() - ref.getWindow().getStart() - this.NUM_BASES_ON_EITHER_SIDE, 0);
        String allBases = new String(ref.getBases());
        String localBases = allBases.substring(basesToDiscardInFront, endIndex = Math.min(basesToDiscardInFront + 2 * this.NUM_BASES_ON_EITHER_SIDE + 1, allBases.length()));
        if (localBases.length() < this.REFERENCE_CONTEXT_LENGTH) {
            localBases = String.join((CharSequence)"", localBases, StringUtils.repeat((String)"N", (int)(this.REFERENCE_CONTEXT_LENGTH - localBases.length())));
        }
        return Collections.singletonMap(REFERENCE_BASES_KEY, localBases);
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(REFERENCE_BASES_KEY, 1, VCFHeaderLineType.String, "local reference bases."));
    }

    public static String getNMiddleBases(String bases, int n) {
        Utils.validateArg(bases.length() >= n, "bases must have n or more bases. bases = " + bases);
        Utils.validateArg(bases.length() % 2 == 1, "the length of bases must be an odd number");
        Utils.validateArg(n % 2 == 1, "n must be odd");
        int numBasesOnEachSide = n / 2;
        int middleIndex = bases.length() / 2;
        return bases.substring(middleIndex - numBasesOnEachSide, middleIndex + numBasesOnEachSide + 1);
    }
}

