/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="List of samples that are not homozygous reference at a variant site (Samples)")
public final class SampleList
extends InfoFieldAnnotation {
    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (vc.isMonomorphicInSamples() || !vc.hasGenotypes()) {
            return Collections.emptyMap();
        }
        StringBuilder samples = new StringBuilder();
        for (Genotype genotype : vc.getGenotypesOrderedByName()) {
            if (!genotype.isCalled() || genotype.isHomRef()) continue;
            if (samples.length() > 0) {
                samples.append(",");
            }
            samples.append(genotype.getSampleName());
        }
        if (samples.length() == 0) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.getKeyNames().get(0), samples.toString());
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("Samples");
    }
}

