/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.annotator.FisherStrand;
import org.broadinstitute.hellbender.tools.walkers.annotator.GenotypeAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardMutectAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Number of forward and reverse reads that support REF and ALT alleles (SB)")
public final class StrandBiasBySample
extends GenotypeAnnotation
implements StandardMutectAnnotation {
    private static final Logger logger = LogManager.getLogger(StrandBiasBySample.class);
    private static final int ARRAY_DIM = 2;

    @Override
    public void annotate(ReferenceContext ref, VariantContext vc, Genotype g, GenotypeBuilder gb, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        Utils.nonNull(g);
        Utils.nonNull(gb);
        if (likelihoods == null || !g.isCalled()) {
            logger.warn(AnnotationUtils.generateMissingDataWarning(vc, g, likelihoods));
            return;
        }
        int[][] table = FisherStrand.getContingencyTable(likelihoods, vc, 0, Arrays.asList(g.getSampleName()));
        gb.attribute("SB", StrandBiasBySample.getContingencyArray(table));
    }

    @VisibleForTesting
    static List<Integer> getContingencyArray(int[][] table) {
        if (table.length != 2 || table[0].length != 2) {
            throw new IllegalArgumentException("Expecting a 2x2 strand bias table.");
        }
        ArrayList<Integer> list = new ArrayList<Integer>(4);
        list.add(table[0][0]);
        list.add(table[0][1]);
        list.add(table[1][0]);
        list.add(table[1][1]);
        return list;
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("SB");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Collections.singletonList(GATKVCFHeaderLines.getFormatLine(this.getKeyNames().get(0)));
    }

    public static int getAltForwardCountFromFlattenedContingencyTable(int[] contingencyTable) {
        return contingencyTable[2];
    }

    public static int getAltReverseCountFromFlattenedContingencyTable(int[] contingencyTable) {
        return contingencyTable[3];
    }
}

