/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class StrandBiasTest
extends InfoFieldAnnotation {
    protected static final int ARRAY_DIM = 2;
    protected static final int ARRAY_SIZE = 4;

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (!vc.isVariant()) {
            return Collections.emptyMap();
        }
        if (vc.hasGenotypes()) {
            for (Genotype g : vc.getGenotypes()) {
                if (!g.hasAnyAttribute("SB")) continue;
                return this.calculateAnnotationFromGTfield(vc.getGenotypes());
            }
        }
        if (likelihoods != null) {
            return this.calculateAnnotationFromLikelihoods(likelihoods, vc);
        }
        return Collections.emptyMap();
    }

    protected abstract Map<String, Object> calculateAnnotationFromGTfield(GenotypesContext var1);

    protected abstract Map<String, Object> calculateAnnotationFromLikelihoods(AlleleLikelihoods<GATKRead, Allele> var1, VariantContext var2);

    protected int[][] getTableFromSamples(GenotypesContext genotypes, int minCount) {
        if (genotypes == null) {
            return null;
        }
        int[] sbArray = new int[]{0, 0, 0, 0};
        boolean foundData = false;
        for (Genotype g : genotypes) {
            if (!g.hasAnyAttribute("SB")) continue;
            foundData = true;
            int[] data = StrandBiasTest.getStrandCounts(g);
            if (!StrandBiasTest.passesMinimumThreshold(data, minCount)) continue;
            for (int index = 0; index < sbArray.length; ++index) {
                int n = index;
                sbArray[n] = sbArray[n] + data[index];
            }
        }
        return foundData ? StrandBiasTest.decodeSBBS(sbArray) : (int[][])null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int[] getStrandCounts(Genotype g) {
        if (g.getAnyAttribute("SB").getClass().equals(String.class)) {
            String sbbsString = (String)g.getAnyAttribute("SB");
            return StrandBiasTest.encodeSBBS(sbbsString);
        }
        if (!g.getAnyAttribute("SB").getClass().equals(ArrayList.class)) throw new GATKException("Unexpected SB type");
        if (((ArrayList)g.getAnyAttribute("SB")).get(0) instanceof Integer) {
            return StrandBiasTest.encodeSBBS((ArrayList)g.getAnyAttribute("SB"));
        }
        if (!(((ArrayList)g.getAnyAttribute("SB")).get(0) instanceof String)) throw new GATKException("Unexpected SB type");
        ArrayList<Integer> sbbsList = new ArrayList<Integer>();
        Iterator iterator = ((ArrayList)g.getAnyAttribute("SB")).iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            sbbsList.add(Integer.parseInt(o.toString()));
        }
        return StrandBiasTest.encodeSBBS(sbbsList);
    }

    public static int[][] getContingencyTable(AlleleLikelihoods<GATKRead, Allele> likelihoods, VariantContext vc, int minCount) {
        return StrandBiasTest.getContingencyTable(likelihoods, vc, minCount, likelihoods.samples());
    }

    public static int[][] getContingencyTable(AlleleLikelihoods<GATKRead, Allele> likelihoods, VariantContext vc, int minCount, Collection<String> samples) {
        if (likelihoods == null || vc == null) {
            return null;
        }
        Allele ref = vc.getReference();
        List allAlts = vc.getAlternateAlleles();
        int[][] table = new int[2][2];
        for (String sample : samples) {
            int[] sampleTable = new int[4];
            likelihoods.bestAllelesBreakingTies(sample).stream().filter(ba -> ba.isInformative()).forEach(ba -> StrandBiasTest.updateTable(sampleTable, ba.allele, (GATKRead)ba.evidence, ref, allAlts));
            if (!StrandBiasTest.passesMinimumThreshold(sampleTable, minCount)) continue;
            StrandBiasTest.copyToMainTable(sampleTable, table);
        }
        return table;
    }

    private static void copyToMainTable(int[] perSampleTable, int[][] mainTable) {
        int[] nArray = mainTable[0];
        nArray[0] = nArray[0] + perSampleTable[0];
        int[] nArray2 = mainTable[0];
        nArray2[1] = nArray2[1] + perSampleTable[1];
        int[] nArray3 = mainTable[1];
        nArray3[0] = nArray3[0] + perSampleTable[2];
        int[] nArray4 = mainTable[1];
        nArray4[1] = nArray4[1] + perSampleTable[3];
    }

    private static void updateTable(int[] table, Allele allele, GATKRead read, Allele ref, List<Allele> allAlts) {
        boolean matchesRef = allele.equals(ref, true);
        boolean matchesAnyAlt = allAlts.contains(allele);
        if (matchesRef || matchesAnyAlt) {
            int offset = matchesRef ? 0 : 2;
            boolean isForward = !read.isReverseStrand();
            int n = offset + (isForward ? 0 : 1);
            table[n] = table[n] + 1;
        }
    }

    protected static boolean passesMinimumThreshold(int[] data, int minCount) {
        return data[0] + data[1] + data[2] + data[3] > minCount;
    }

    private static int[] encodeSBBS(String string) {
        int[] array = new int[4];
        StringTokenizer tokenizer = new StringTokenizer(string, ",", false);
        for (int index = 0; index < 4; ++index) {
            array[index] = Integer.parseInt(tokenizer.nextToken());
        }
        return array;
    }

    private static int[] encodeSBBS(List<Integer> arrayList) {
        int[] array = new int[4];
        int index = 0;
        for (Integer item : arrayList) {
            array[index++] = item;
        }
        return array;
    }

    public static int[][] decodeSBBS(int[] array) {
        if (array.length != 4) {
            return null;
        }
        int[][] table = new int[2][2];
        table[0][0] = array[0];
        table[0][1] = array[1];
        table[1][0] = array[2];
        table[1][1] = array[3];
        return table;
    }
}

