/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StrandBiasTest;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Strand bias estimated by the symmetric odds ratio test (SOR)")
public final class StrandOddsRatio
extends StrandBiasTest
implements StandardAnnotation {
    private static final double PSEUDOCOUNT = 1.0;
    private static final int MIN_COUNT = 0;

    @Override
    protected Map<String, Object> calculateAnnotationFromGTfield(GenotypesContext genotypes) {
        int[][] tableFromPerSampleAnnotations = this.getTableFromSamples(genotypes, 0);
        return tableFromPerSampleAnnotations != null ? this.annotationForOneTable(StrandOddsRatio.calculateSOR(tableFromPerSampleAnnotations)) : null;
    }

    @Override
    protected Map<String, Object> calculateAnnotationFromLikelihoods(AlleleLikelihoods<GATKRead, Allele> likelihoods, VariantContext vc) {
        int[][] table = StrandOddsRatio.getContingencyTable(likelihoods, vc, 0);
        return this.annotationForOneTable(StrandOddsRatio.calculateSOR(table));
    }

    public static double calculateSOR(int[][] table) {
        double t00 = (double)table[0][0] + 1.0;
        double t01 = (double)table[0][1] + 1.0;
        double t11 = (double)table[1][1] + 1.0;
        double t10 = (double)table[1][0] + 1.0;
        double ratio = t00 / t01 * (t11 / t10) + t01 / t00 * (t10 / t11);
        double refRatio = Math.min(t00, t01) / Math.max(t00, t01);
        double altRatio = Math.min(t10, t11) / Math.max(t10, t11);
        return Math.log(ratio) + Math.log(refRatio) - Math.log(altRatio);
    }

    @VisibleForTesting
    Map<String, Object> annotationForOneTable(double sor) {
        return Collections.singletonMap(this.getKeyNames().get(0), StrandOddsRatio.formattedValue(sor));
    }

    public static String formattedValue(double sor) {
        return String.format("%.3f", sor);
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("SOR");
    }
}

