/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.StandardMutectAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Tandem repeat unit composition and counts per allele (STR, RU, RPA)")
public final class TandemRepeat
extends InfoFieldAnnotation
implements StandardMutectAnnotation {
    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        if (!vc.isIndel()) {
            return Collections.emptyMap();
        }
        Pair<List<Integer>, byte[]> result = TandemRepeat.getNumTandemRepeatUnits(ref, vc);
        if (result == null) {
            return Collections.emptyMap();
        }
        byte[] repeatUnit = (byte[])result.getRight();
        List numUnits = (List)result.getLeft();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("STR", true);
        map.put("RU", new String(repeatUnit));
        map.put("RPA", numUnits);
        return Collections.unmodifiableMap(map);
    }

    public static Pair<List<Integer>, byte[]> getNumTandemRepeatUnits(ReferenceContext ref, VariantContext vc) {
        byte[] refBases = ref.getBases();
        int startIndex = vc.getStart() + 1 - ref.getWindow().getStart();
        return GATKVariantContextUtils.getNumTandemRepeatUnits(vc, Arrays.copyOfRange(refBases, startIndex, refBases.length));
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("STR", "RU", "RPA");
    }
}

