/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.collect.ImmutableMap;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotation;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVCFHeaderLines;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Number of non-duplicate-insert ALT reads (AS_UNIQ_ALT_READ_COUNT)")
public class UniqueAltReadCount
extends InfoFieldAnnotation
implements AlleleSpecificAnnotation {
    public static final String KEY = "AS_UNIQ_ALT_READ_COUNT";

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList(KEY);
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Collections.singletonList(GATKVCFHeaderLines.getInfoLine(KEY));
    }

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        List uniqueCountsPerAllele = vc.getAlternateAlleles().stream().map(altAllele -> {
            Map<ImmutablePair, Long> duplicateReadMap = likelihoods.bestAllelesBreakingTies().stream().filter(ba -> ba.allele.equals(altAllele) && ba.isInformative()).map(ba -> new ImmutablePair((Object)((GATKRead)ba.evidence).getStart(), (Object)((GATKRead)ba.evidence).getFragmentLength())).collect(Collectors.groupingBy(x -> x, Collectors.counting()));
            return duplicateReadMap.size();
        }).collect(Collectors.toList());
        return ImmutableMap.of((Object)KEY, (Object)AnnotationUtils.encodeAnyASListWithRawDelim(uniqueCountsPerAllele));
    }
}

