/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import com.google.common.collect.Lists;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.cmdline.argumentcollections.DbsnpArgumentCollection;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReadsContext;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.engine.VariantWalker;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.engine.filters.ReadFilterLibrary;
import org.broadinstitute.hellbender.engine.filters.WellformedReadFilter;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.AssemblyBasedCallerUtils;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.genotyper.IndexedAlleleList;
import org.broadinstitute.hellbender.utils.genotyper.IndexedSampleList;
import org.broadinstitute.hellbender.utils.genotyper.LikelihoodMatrix;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.hellbender.utils.variant.VcfUtils;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="Tool for adding annotations to VCF files", oneLineSummary="Tool for adding annotations to VCF files", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class VariantAnnotator
extends VariantWalker {
    public static final String EXPRESSION_LONG_NAME = "expression";
    public static final String EXPRESSION_SHORT_NAME = "E";
    private SAMSequenceDictionary sequenceDictionary;
    private VariantContextWriter vcfWriter;
    private static final int REFERENCE_PADDING = 100;
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Advanced
    @Argument(fullName="comparison", shortName="comp", doc="Comparison VCF file(s)", optional=true)
    public List<FeatureInput<VariantContext>> comps = new ArrayList<FeatureInput<VariantContext>>();
    @Argument(fullName="resource", doc="External resource VCF file", optional=true)
    public List<FeatureInput<VariantContext>> resources;
    @Argument(fullName="output", shortName="O", doc="The file to which variants should be written", optional=false)
    protected File outputFile;
    @Argument(fullName="expression", shortName="E", doc="One or more specific expressions to apply to variant calls", optional=true)
    protected Set<String> expressionsToUse = new HashSet<String>();
    @Argument(fullName="resource-allele-concordance", shortName="rac", doc="Check for allele concordances when using an external resource VCF file", optional=true)
    protected Boolean expressionAlleleConcordance = false;
    @Argument(fullName="min-base-quality-score", doc="Minimum base quality required to confidently assign a read to an allele", optional=true)
    public byte minBaseQualityScore = (byte)10;
    private VariantAnnotatorEngine annotatorEngine;
    private SampleList variantSamples;

    @Override
    public List<ReadFilter> getDefaultReadFilters() {
        return Lists.newArrayList((Object[])new ReadFilter[]{new WellformedReadFilter(), ReadFilterLibrary.NOT_DUPLICATE, ReadFilterLibrary.PRIMARY_LINE, ReadFilterLibrary.PASSES_VENDOR_QUALITY_CHECK, ReadFilterLibrary.MAPPED});
    }

    @Override
    public boolean useVariantAnnotations() {
        return true;
    }

    @Override
    public void onTraversalStart() {
        List samples = this.getHeaderForVariants().getGenotypeSamples();
        this.sequenceDictionary = this.getBestAvailableSequenceDictionary();
        this.variantSamples = new IndexedSampleList(samples);
        if (this.hasReads()) {
            Set<String> readsSamples = this.getHeaderForReads().getReadGroups().stream().map(rg -> rg.getSample()).collect(Collectors.toSet());
            readsSamples.forEach(readSample -> {
                if (!samples.contains(readSample)) {
                    throw new UserException(String.format("Reads sample '%s' from readgroups tags does not match any sample in the variant genotypes", readSample));
                }
            });
        }
        this.annotatorEngine = new VariantAnnotatorEngine(this.makeVariantAnnotations(), this.dbsnp.dbsnp, this.comps, false, false);
        this.annotatorEngine.addExpressions(this.expressionsToUse, this.resources, this.expressionAlleleConcordance);
        Set<VCFHeaderLine> hInfo = new HashSet<VCFHeaderLine>();
        hInfo.addAll(this.annotatorEngine.getVCFAnnotationDescriptions(false));
        hInfo.addAll(this.getHeaderForVariants().getMetaDataInInputOrder());
        hInfo = VcfUtils.updateHeaderContigLines(hInfo, this.hasReference() ? this.referenceArguments.getReferencePath() : null, this.hasReference() ? this.getReferenceDictionary() : this.sequenceDictionary, false);
        this.vcfWriter = this.createVCFWriter(this.outputFile);
        this.vcfWriter.writeHeader(new VCFHeader(hInfo, samples));
    }

    @Override
    public void apply(VariantContext vc, ReadsContext readsContext, ReferenceContext refContext, FeatureContext fc) {
        if (refContext.getBases().length == 0 || BaseUtils.simpleBaseToBaseIndex(refContext.getBase()) != -1) {
            ReferenceContext expandedRefContext = !this.hasReference() ? refContext : new ReferenceContext(refContext, new SimpleInterval((Locatable)vc).expandWithinContig(100, this.sequenceDictionary));
            VariantContext annotatedVC = this.annotatorEngine.annotateContext(vc, fc, expandedRefContext, this.makeLikelihoods(vc, readsContext), a -> true);
            this.vcfWriter.add(annotatedVC);
        } else {
            this.vcfWriter.add(vc);
        }
    }

    private AlleleLikelihoods<GATKRead, Allele> makeLikelihoods(VariantContext vc, ReadsContext readsContext) {
        List<GATKRead> reads = Utils.stream(readsContext).collect(Collectors.toList());
        AlleleLikelihoods<GATKRead, Allele> result = new AlleleLikelihoods<GATKRead, Allele>(this.variantSamples, new IndexedAlleleList(vc.getAlleles()), AssemblyBasedCallerUtils.splitReadsBySample(this.variantSamples, this.getHeaderForReads(), reads));
        ReadPileup readPileup = new ReadPileup((Locatable)vc, readsContext);
        Map<String, ReadPileup> pileupsBySample = readPileup.splitBySample(this.getHeaderForReads(), "__UNKNOWN__");
        Allele refAllele = vc.getReference();
        List altAlleles = vc.getAlternateAlleles();
        int numAlleles = vc.getNAlleles();
        for (Map.Entry<String, ReadPileup> samplePileups : pileupsBySample.entrySet()) {
            LikelihoodMatrix<GATKRead, Allele> sampleMatrix = result.sampleMatrix(result.indexOfSample(samplePileups.getKey()));
            MutableInt readIndex = new MutableInt(0);
            for (PileupElement pe : samplePileups.getValue()) {
                IntStream.range(0, numAlleles).forEach(a -> sampleMatrix.set(a, readIndex.intValue(), Double.NEGATIVE_INFINITY));
                Allele pileupAllele = GATKVariantContextUtils.chooseAlleleForRead(pe, refAllele, altAlleles, this.minBaseQualityScore);
                if (pileupAllele != null) {
                    sampleMatrix.set(sampleMatrix.indexOfAllele(pileupAllele), readIndex.intValue(), 0.0);
                }
                readIndex.increment();
            }
        }
        return result;
    }

    @Override
    public void closeTool() {
        if (this.vcfWriter != null) {
            this.vcfWriter.close();
        }
    }
}

