/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.tools.walkers.annotator.Annotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.GenotypeAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.VariantOverlapAnnotator;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotationData;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public final class VariantAnnotatorEngine {
    private final List<InfoFieldAnnotation> infoAnnotations;
    private final List<GenotypeAnnotation> genotypeAnnotations;
    private Set<String> reducibleKeys;
    private List<VAExpression> expressions = new ArrayList<VAExpression>();
    private final VariantOverlapAnnotator variantOverlapAnnotator;
    private boolean expressionAlleleConcordance;
    private final boolean useRawAnnotations;
    private final boolean keepRawCombinedAnnotations;
    private static final Logger logger = LogManager.getLogger(VariantAnnotatorEngine.class);

    public VariantAnnotatorEngine(Collection<Annotation> annotationList, FeatureInput<VariantContext> dbSNPInput, List<FeatureInput<VariantContext>> featureInputs, boolean useRaw, boolean keepCombined) {
        Utils.nonNull(featureInputs, "comparisonFeatureInputs is null");
        this.infoAnnotations = new ArrayList<InfoFieldAnnotation>();
        this.genotypeAnnotations = new ArrayList<GenotypeAnnotation>();
        for (Annotation annotation : annotationList) {
            if (annotation instanceof InfoFieldAnnotation) {
                this.infoAnnotations.add((InfoFieldAnnotation)annotation);
            }
            if (!(annotation instanceof GenotypeAnnotation)) continue;
            this.genotypeAnnotations.add((GenotypeAnnotation)annotation);
        }
        this.variantOverlapAnnotator = this.initializeOverlapAnnotator(dbSNPInput, featureInputs);
        this.reducibleKeys = new LinkedHashSet<String>();
        this.useRawAnnotations = useRaw;
        this.keepRawCombinedAnnotations = keepCombined;
        for (InfoFieldAnnotation infoFieldAnnotation : this.infoAnnotations) {
            if (!(infoFieldAnnotation instanceof ReducibleAnnotation)) continue;
            for (String rawKey : ((ReducibleAnnotation)((Object)infoFieldAnnotation)).getRawKeyNames()) {
                this.reducibleKeys.add(rawKey);
            }
        }
    }

    private VariantOverlapAnnotator initializeOverlapAnnotator(FeatureInput<VariantContext> dbSNPInput, List<FeatureInput<VariantContext>> featureInputs) {
        LinkedHashMap<FeatureInput<VariantContext>, String> overlaps = new LinkedHashMap<FeatureInput<VariantContext>, String>();
        for (FeatureInput<VariantContext> fi : featureInputs) {
            overlaps.put(fi, fi.getName());
        }
        if (overlaps.values().contains("DB")) {
            throw new GATKException("The map of overlaps must not contain DB");
        }
        if (dbSNPInput != null) {
            overlaps.put(dbSNPInput, "DB");
        }
        return new VariantOverlapAnnotator(dbSNPInput, overlaps);
    }

    public List<GenotypeAnnotation> getGenotypeAnnotations() {
        return Collections.unmodifiableList(this.genotypeAnnotations);
    }

    public List<InfoFieldAnnotation> getInfoAnnotations() {
        return Collections.unmodifiableList(this.infoAnnotations);
    }

    public Set<VCFHeaderLine> getVCFAnnotationDescriptions() {
        return this.getVCFAnnotationDescriptions(false);
    }

    public Set<VCFHeaderLine> getVCFAnnotationDescriptions(boolean useRaw) {
        LinkedHashSet<VCFHeaderLine> descriptions = new LinkedHashSet<VCFHeaderLine>();
        for (InfoFieldAnnotation infoFieldAnnotation : this.infoAnnotations) {
            if (infoFieldAnnotation instanceof ReducibleAnnotation) {
                if (useRaw || this.keepRawCombinedAnnotations) {
                    descriptions.addAll(((ReducibleAnnotation)((Object)infoFieldAnnotation)).getRawDescriptions());
                }
                if (useRaw) continue;
                descriptions.addAll(infoFieldAnnotation.getDescriptions());
                continue;
            }
            descriptions.addAll(infoFieldAnnotation.getDescriptions());
        }
        for (GenotypeAnnotation genotypeAnnotation : this.genotypeAnnotations) {
            descriptions.addAll(genotypeAnnotation.getDescriptions());
        }
        for (String string : this.variantOverlapAnnotator.getOverlapNames()) {
            if (VCFStandardHeaderLines.getInfoLine((String)string, (boolean)false) != null) {
                descriptions.add((VCFHeaderLine)VCFStandardHeaderLines.getInfoLine((String)string));
                continue;
            }
            descriptions.add((VCFHeaderLine)new VCFInfoHeaderLine(string, 0, VCFHeaderLineType.Flag, string + " Membership"));
        }
        for (VAExpression vAExpression : this.getRequestedExpressions()) {
            VCFInfoHeaderLine lineToAdd;
            if (vAExpression.fieldName.equals("ID")) {
                descriptions.add((VCFHeaderLine)new VCFInfoHeaderLine(vAExpression.fullName, 1, VCFHeaderLineType.String, "ID field transferred from external VCF resource"));
                continue;
            }
            VCFInfoHeaderLine targetHeaderLine = ((VCFHeader)new FeatureDataSource(vAExpression.binding, 100, VariantContext.class).getHeader()).getInfoHeaderLines().stream().filter(l -> l.getID().equals(expression.fieldName)).findFirst().orElse(null);
            if (targetHeaderLine != null) {
                vAExpression.sethInfo(targetHeaderLine);
                lineToAdd = targetHeaderLine.getCountType() == VCFHeaderLineCount.INTEGER ? new VCFInfoHeaderLine(vAExpression.fullName, targetHeaderLine.getCount(), targetHeaderLine.getType(), targetHeaderLine.getDescription()) : new VCFInfoHeaderLine(vAExpression.fullName, targetHeaderLine.getCountType(), targetHeaderLine.getType(), targetHeaderLine.getDescription());
            } else {
                lineToAdd = new VCFInfoHeaderLine(vAExpression.fullName, VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Value transferred from another external VCF resource");
                logger.warn(String.format("The requested expression attribute \"%s\" is missing from the header in its resource file %s", vAExpression.fullName, vAExpression.binding.getName()));
            }
            descriptions.add((VCFHeaderLine)lineToAdd);
            vAExpression.sethInfo(lineToAdd);
        }
        Utils.validate(!descriptions.contains(null), "getVCFAnnotationDescriptions should not contain null. This error is likely due to an incorrect implementation of getDescriptions() in one or more of the annotation classes");
        return descriptions;
    }

    public Map<String, Object> combineAnnotations(List<Allele> allelesList, Map<String, List<?>> annotationMap) {
        HashMap<String, Object> combinedAnnotations = new HashMap<String, Object>();
        for (InfoFieldAnnotation annotationType : this.infoAnnotations) {
            if (!(annotationType instanceof ReducibleAnnotation)) continue;
            ReducibleAnnotation currentASannotation = (ReducibleAnnotation)((Object)annotationType);
            for (String rawKey : currentASannotation.getRawKeyNames()) {
                if (!annotationMap.containsKey(rawKey)) continue;
                List<ReducibleAnnotationData<?>> annotationValue = annotationMap.get(rawKey);
                Map<String, Object> annotationsFromCurrentType = currentASannotation.combineRawData(allelesList, annotationValue);
                combinedAnnotations.putAll(annotationsFromCurrentType);
                annotationMap.keySet().removeAll(currentASannotation.getRawKeyNames());
            }
        }
        return combinedAnnotations;
    }

    public VariantContext finalizeAnnotations(VariantContext vc, VariantContext originalVC) {
        LinkedHashMap<String, Object> variantAnnotations = new LinkedHashMap<String, Object>(vc.getAttributes());
        for (InfoFieldAnnotation annotationType : this.infoAnnotations) {
            if (!(annotationType instanceof ReducibleAnnotation)) continue;
            ReducibleAnnotation currentASannotation = (ReducibleAnnotation)((Object)annotationType);
            Map<String, Object> annotationsFromCurrentType = currentASannotation.finalizeRawData(vc, originalVC);
            if (annotationsFromCurrentType != null) {
                variantAnnotations.putAll(annotationsFromCurrentType);
            }
            for (String rawKey : currentASannotation.getRawKeyNames()) {
                if (this.keepRawCombinedAnnotations) continue;
                variantAnnotations.remove(rawKey);
            }
        }
        if (!this.keepRawCombinedAnnotations) {
            variantAnnotations.remove("AS_QUAL");
        }
        VariantContextBuilder builder = new VariantContextBuilder(vc).attributes(variantAnnotations);
        VariantContext annotated = builder.make();
        return annotated;
    }

    public VariantContext annotateContext(VariantContext vc, FeatureContext features, ReferenceContext ref, AlleleLikelihoods<GATKRead, Allele> likelihoods, Predicate<VariantAnnotation> addAnnot) {
        Utils.nonNull(vc, "vc cannot be null");
        Utils.nonNull(features, "features cannot be null");
        Utils.nonNull(addAnnot, "addAnnot cannot be null");
        VariantContextBuilder builder = new VariantContextBuilder(vc);
        builder.genotypes(this.annotateGenotypes(ref, vc, likelihoods, addAnnot));
        VariantContext newGenotypeAnnotatedVC = builder.make();
        LinkedHashMap<String, Object> infoAnnotMap = new LinkedHashMap<String, Object>(newGenotypeAnnotatedVC.getAttributes());
        this.annotateExpressions(vc, features, ref, infoAnnotMap);
        for (InfoFieldAnnotation annotationType : this.infoAnnotations) {
            Map<String, Object> annotationsFromCurrentType;
            if (!addAnnot.test(annotationType) || (annotationsFromCurrentType = this.useRawAnnotations && annotationType instanceof ReducibleAnnotation ? ((ReducibleAnnotation)((Object)annotationType)).annotateRawData(ref, newGenotypeAnnotatedVC, likelihoods) : annotationType.annotate(ref, newGenotypeAnnotatedVC, likelihoods)) == null) continue;
            infoAnnotMap.putAll(annotationsFromCurrentType);
        }
        VariantContext annotated = builder.attributes(infoAnnotMap).make();
        return this.variantOverlapAnnotator.annotateOverlaps(features, this.variantOverlapAnnotator.annotateRsID(features, annotated));
    }

    private GenotypesContext annotateGenotypes(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods, Predicate<VariantAnnotation> addAnnot) {
        if (this.genotypeAnnotations.isEmpty()) {
            return vc.getGenotypes();
        }
        GenotypesContext genotypes = GenotypesContext.create((int)vc.getNSamples());
        for (Genotype genotype : vc.getGenotypes()) {
            GenotypeBuilder gb = new GenotypeBuilder(genotype);
            for (GenotypeAnnotation annotation : this.genotypeAnnotations) {
                if (!addAnnot.test(annotation)) continue;
                annotation.annotate(ref, vc, genotype, gb, likelihoods);
            }
            genotypes.add(gb.make());
        }
        return genotypes;
    }

    public boolean isRequestedReducibleRawKey(String key) {
        return this.reducibleKeys.contains(key);
    }

    protected List<VAExpression> getRequestedExpressions() {
        return this.expressions;
    }

    public void addExpressions(Set<String> expressionsToUse, List<FeatureInput<VariantContext>> dataSources, boolean expressionAlleleConcordance) {
        for (String expression : expressionsToUse) {
            this.expressions.add(new VAExpression(expression, dataSources));
        }
        this.expressionAlleleConcordance = expressionAlleleConcordance;
    }

    private void annotateExpressions(VariantContext vc, FeatureContext features, ReferenceContext ref, Map<String, Object> attributes) {
        Utils.nonNull(vc);
        for (VAExpression expression : this.expressions) {
            boolean useAltAlleles;
            List variantContexts = features.getValues(expression.binding, vc.getStart());
            if (variantContexts.isEmpty()) continue;
            VariantContext expressionVC = (VariantContext)variantContexts.iterator().next();
            if (expression.fieldName.equals("ID")) {
                if (!expressionVC.hasID()) continue;
                attributes.put(expression.fullName, expressionVC.getID());
                continue;
            }
            if (expression.fieldName.equals("ALT")) {
                attributes.put(expression.fullName, expressionVC.getAlternateAllele(0).getDisplayString());
                continue;
            }
            if (expression.fieldName.equals("FILTER")) {
                String filterString = expressionVC.isFiltered() ? expressionVC.getFilters().stream().collect(Collectors.joining(",")) : "PASS";
                attributes.put(expression.fullName, filterString);
                continue;
            }
            if (!expressionVC.hasAttribute(expression.fieldName)) continue;
            VCFInfoHeaderLine hInfo = expression.hInfo;
            if (hInfo == null) {
                throw new UserException("Cannot annotate expression " + expression.fullName + " at " + ref.getInterval() + " for variant allele(s) " + vc.getAlleles() + ", missing header info");
            }
            boolean useRefAndAltAlleles = VCFHeaderLineCount.R == hInfo.getCountType();
            boolean bl = useAltAlleles = VCFHeaderLineCount.A == hInfo.getCountType();
            if (useAltAlleles || useRefAndAltAlleles || this.expressionAlleleConcordance) {
                String cleanedExpressionValue = expressionVC.getAttribute(expression.fieldName, (Object)"").toString().replaceAll("[\\[\\]\\s]", "");
                ArrayList<String> expressionValuesList = new ArrayList<String>(Arrays.asList(cleanedExpressionValue.split(",")));
                boolean canAnnotate = false;
                List<VariantContext> minBiallelicVCs = this.getMinRepresentationBiallelics(vc);
                List<VariantContext> minBiallelicExprVCs = this.getMinRepresentationBiallelics(expressionVC);
                ArrayList<String> annotationValues = new ArrayList<String>();
                for (VariantContext biallelicVC : minBiallelicVCs) {
                    List exprAlleles = biallelicVC.getAlleles();
                    boolean isAlleleConcordant = false;
                    int i = 0;
                    for (VariantContext biallelicExprVC : minBiallelicExprVCs) {
                        List alleles = biallelicExprVC.getAlleles();
                        if (alleles.equals(exprAlleles)) {
                            if (i == 0 && useRefAndAltAlleles) {
                                annotationValues.add(expressionValuesList.get(i++));
                            }
                            annotationValues.add(expressionValuesList.get(i));
                            isAlleleConcordant = true;
                            canAnnotate = true;
                            break;
                        }
                        ++i;
                    }
                    if (isAlleleConcordant) continue;
                    annotationValues.add("0");
                }
                if (!canAnnotate) continue;
                attributes.put(expression.fullName, annotationValues);
                continue;
            }
            attributes.put(expression.fullName, expressionVC.getAttribute(expression.fieldName));
        }
    }

    private List<VariantContext> getMinRepresentationBiallelics(VariantContext vc) {
        ArrayList<VariantContext> minRepresentationBiallelicVCs = new ArrayList<VariantContext>();
        if (vc.getNAlleles() > 2) {
            for (int i = 1; i < vc.getNAlleles(); ++i) {
                if (vc.getReference().length() != 1 || vc.getAlternateAllele(i - 1).length() != 1) {
                    minRepresentationBiallelicVCs.add(GATKVariantContextUtils.trimAlleles(new VariantContextBuilder(vc).alleles(Arrays.asList(vc.getReference(), vc.getAlternateAllele(i - 1))).attributes(this.removeIrrelevantAttributes(vc.getAttributes())).make(), true, true));
                    continue;
                }
                minRepresentationBiallelicVCs.add(new VariantContextBuilder(vc).alleles(Arrays.asList(vc.getReference(), vc.getAlternateAllele(i - 1))).attributes(this.removeIrrelevantAttributes(vc.getAttributes())).make());
            }
        } else {
            minRepresentationBiallelicVCs.add(vc);
        }
        return minRepresentationBiallelicVCs;
    }

    private Map<String, Object> removeIrrelevantAttributes(Map<String, Object> attributes) {
        HashMap<String, Object> ret = new HashMap<String, Object>(attributes);
        for (String key : attributes.keySet()) {
            if (key.equals("AC") || key.equals("AF") || key.equals("AN")) continue;
            ret.remove(key);
        }
        return ret;
    }

    public static class VAExpression {
        private final String fullName;
        private final String fieldName;
        private final FeatureInput<VariantContext> binding;
        private VCFInfoHeaderLine hInfo;

        public VAExpression(String fullExpression, List<FeatureInput<VariantContext>> dataSourceList) {
            int indexOfDot = fullExpression.lastIndexOf(".");
            if (indexOfDot == -1) {
                throw new UserException.BadInput("The requested expression '" + fullExpression + "' is invalid, it should be in VCFFile.value format");
            }
            this.fullName = fullExpression;
            this.fieldName = fullExpression.substring(indexOfDot + 1);
            String bindingName = fullExpression.substring(0, indexOfDot);
            Optional<FeatureInput> binding = dataSourceList.stream().filter(ds -> ds.getName().equals(bindingName)).findFirst();
            if (!binding.isPresent()) {
                throw new UserException.BadInput("The requested expression '" + fullExpression + "' is invalid, could not find vcf input file");
            }
            this.binding = binding.get();
        }

        public void sethInfo(VCFInfoHeaderLine hInfo) {
            this.hInfo = hInfo;
        }
    }
}

