/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator;

import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.broadinstitute.hellbender.engine.FeatureContext;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAssignmentMethod;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public final class VariantOverlapAnnotator {
    private final FeatureInput<VariantContext> dbSNP;
    private final Map<FeatureInput<VariantContext>, String> overlaps;

    public VariantOverlapAnnotator(FeatureInput<VariantContext> dbSNP) {
        this(dbSNP, Collections.emptyMap());
    }

    public VariantOverlapAnnotator(FeatureInput<VariantContext> dbSNP, Map<FeatureInput<VariantContext>, String> overlaps) {
        Utils.nonNull(overlaps, "overlaps cannot be null");
        this.dbSNP = dbSNP;
        this.overlaps = overlaps;
    }

    public VariantContext annotateRsID(FeatureContext featureContext, VariantContext vcToAnnotate) {
        if (this.dbSNP != null) {
            SimpleInterval loc = new SimpleInterval((Locatable)vcToAnnotate);
            return VariantOverlapAnnotator.annotateRsID(featureContext.getValues(this.dbSNP, loc.getStart()), vcToAnnotate);
        }
        return vcToAnnotate;
    }

    public static VariantContext annotateRsID(List<VariantContext> vcsAtLoc, VariantContext vcToAnnotate) {
        String rsID = VariantOverlapAnnotator.getRsID(vcsAtLoc, vcToAnnotate);
        if (rsID != null) {
            VariantContextBuilder vcb = new VariantContextBuilder(vcToAnnotate);
            if (!vcToAnnotate.hasID()) {
                return vcb.id(rsID).make();
            }
            if (!vcToAnnotate.getID().contains(rsID)) {
                return vcb.id(vcToAnnotate.getID() + ";" + rsID).make();
            }
        }
        return vcToAnnotate;
    }

    public VariantContext annotateOverlaps(FeatureContext featureContext, VariantContext vcToAnnotate) {
        if (this.overlaps.isEmpty()) {
            return vcToAnnotate;
        }
        VariantContext annotated = vcToAnnotate;
        SimpleInterval loc = new SimpleInterval((Locatable)vcToAnnotate);
        for (Map.Entry<FeatureInput<VariantContext>, String> overlap : this.overlaps.entrySet()) {
            FeatureInput<VariantContext> fi = overlap.getKey();
            List<VariantContext> vcs = featureContext.getValues(fi, loc.getStart());
            annotated = this.annotateOverlap(vcs, overlap.getValue(), annotated);
        }
        return annotated;
    }

    public VariantContext annotateOverlap(List<VariantContext> overlapTestVCs, String attributeKey, VariantContext vcToAnnotate) {
        if (this.overlaps.isEmpty()) {
            return vcToAnnotate;
        }
        boolean overlaps = VariantOverlapAnnotator.overlaps(overlapTestVCs, vcToAnnotate);
        if (overlaps) {
            return new VariantContextBuilder(vcToAnnotate).attribute(attributeKey, (Object)true).make();
        }
        return vcToAnnotate;
    }

    private static String getRsID(List<VariantContext> rsIDSourceVCs, VariantContext vcToAnnotate) {
        Utils.nonNull(rsIDSourceVCs, "rsIDSourceVCs cannot be null");
        Utils.nonNull(vcToAnnotate, "vcToAnnotate cannot be null");
        ArrayList<String> rsids = new ArrayList<String>();
        List<VariantContext> vcAnnotateList = GATKVariantContextUtils.splitVariantContextToBiallelics(vcToAnnotate, true, GenotypeAssignmentMethod.SET_TO_NO_CALL_NO_ANNOTATIONS, true);
        block0: for (VariantContext vcCompSource : rsIDSourceVCs) {
            if (vcCompSource.isFiltered()) continue;
            if (!vcCompSource.getContig().equals(vcToAnnotate.getContig())) {
                throw new IllegalArgumentException("source rsID VariantContext " + vcCompSource + " is not on same chromosome as vcToAnnotate " + vcToAnnotate);
            }
            List<VariantContext> vcCompList = GATKVariantContextUtils.splitVariantContextToBiallelics(vcCompSource, true, GenotypeAssignmentMethod.SET_TO_NO_CALL_NO_ANNOTATIONS, true);
            boolean addThisID = false;
            for (VariantContext vcComp : vcCompList) {
                for (VariantContext vcToAnnotateBi : vcAnnotateList) {
                    if (vcComp.getStart() != vcToAnnotateBi.getStart() || !vcToAnnotateBi.getReference().equals((Object)vcComp.getReference()) || !vcComp.getAlternateAlleles().equals(vcToAnnotateBi.getAlternateAlleles())) continue;
                    addThisID = true;
                    break;
                }
                if (!addThisID) continue;
                rsids.add(vcCompSource.getID());
                continue block0;
            }
        }
        return rsids.isEmpty() ? null : String.join((CharSequence)";", rsids);
    }

    private static boolean overlaps(List<VariantContext> potentialOverlaps, VariantContext vcToAnnotate) {
        return VariantOverlapAnnotator.getRsID(potentialOverlaps, vcToAnnotate) != null;
    }

    public Collection<String> getOverlapNames() {
        return this.overlaps.values();
    }
}

