/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.tools.walkers.annotator.FisherStrand;
import org.broadinstitute.hellbender.tools.walkers.annotator.StrandBiasTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StrandBiasTest;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotationData;
import org.broadinstitute.hellbender.utils.QualityUtils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Allele-specific strand bias estimated using Fisher's exact test (AS_FS)")
public class AS_FisherStrand
extends AS_StrandBiasTest
implements AS_StandardAnnotation {
    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("AS_FS");
    }

    @Override
    protected Map<String, Object> calculateAnnotationFromLikelihoods(AlleleLikelihoods<GATKRead, Allele> likelihoods, VariantContext vc) {
        int[][] table = StrandBiasTest.getContingencyTable(likelihoods, vc, 2);
        return table == null ? null : this.annotationForOneTable(FisherStrand.pValueForContingencyTable(table));
    }

    private Map<String, Object> annotationForOneTable(double pValue) {
        return Collections.singletonMap(this.getKeyNames().get(0), FisherStrand.makeValueObjectForAnnotation(pValue));
    }

    @Override
    protected Map<Allele, Double> calculateReducedData(AlleleSpecificAnnotationData<List<Integer>> combinedData) {
        HashMap<Allele, Double> annotationMap = new HashMap<Allele, Double>();
        Map perAlleleData = combinedData.getAttributeMap();
        List refStrandCounts = (List)perAlleleData.get(combinedData.getRefAllele());
        for (Allele a : perAlleleData.keySet()) {
            if (a.equals(combinedData.getRefAllele(), true)) continue;
            List altStrandCounts = (List)combinedData.getAttribute(a);
            int[][] refAltTable = new int[][]{{(Integer)refStrandCounts.get(0), (Integer)refStrandCounts.get(1)}, {(Integer)altStrandCounts.get(0), (Integer)altStrandCounts.get(1)}};
            annotationMap.put(a, QualityUtils.phredScaleErrorRate(Math.max(FisherStrand.pValueForContingencyTable(refAltTable), 1.0E-320)));
        }
        return annotationMap;
    }
}

