/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.annotator.HeterozygosityCalculator;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotation;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Allele-specific likelihood-based test for the consanguinity among samples (AS_InbreedingCoeff)")
public final class AS_InbreedingCoeff
extends InfoFieldAnnotation
implements AS_StandardAnnotation,
AlleleSpecificAnnotation {
    public static final int MIN_SAMPLES = 10;
    private Set<String> founderIds;

    public AS_InbreedingCoeff() {
        this(null);
    }

    public AS_InbreedingCoeff(Set<String> founderIds) {
        this.founderIds = founderIds;
    }

    @Override
    public List<String> getKeyNames() {
        return Collections.singletonList("AS_InbreedingCoeff");
    }

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        Utils.nonNull(vc);
        HeterozygosityCalculator heterozygosityUtils = new HeterozygosityCalculator(vc);
        if (heterozygosityUtils.getSampleCount() < 10) {
            return Collections.emptyMap();
        }
        ArrayList<Double> ICvalues = new ArrayList<Double>();
        for (Allele a : vc.getAlternateAlleles()) {
            ICvalues.add(this.calculateIC(vc, a, heterozygosityUtils));
        }
        return Collections.singletonMap(this.getKeyNames().get(0), AnnotationUtils.encodeValueList(ICvalues, "%.4f"));
    }

    @VisibleForTesting
    public double calculateIC(VariantContext vc, Allele altAllele) {
        return this.calculateIC(vc, altAllele, new HeterozygosityCalculator(vc));
    }

    private double calculateIC(VariantContext vc, Allele altAllele, HeterozygosityCalculator heterozygosityUtils) {
        double F;
        int AN = vc.getCalledChrCount();
        double hetCount = heterozygosityUtils.getHetCount(altAllele);
        if (vc.isBiallelic()) {
            double refAC = heterozygosityUtils.getAlleleCount(vc.getReference());
            double altAC = heterozygosityUtils.getAlleleCount(altAllele);
            double refAF = refAC / (altAC + refAC);
            double altAF = 1.0 - refAF;
            F = 1.0 - hetCount / (2.0 * refAF * altAF * (double)heterozygosityUtils.getSampleCount());
        } else {
            double altAF = heterozygosityUtils.getAlleleCount(altAllele) / (double)AN;
            F = 1.0 - hetCount / (2.0 * (1.0 - altAF) * altAF * (double)heterozygosityUtils.getSampleCount());
        }
        return F;
    }
}

