/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.hellbender.engine.ReferenceContext;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.annotator.InfoFieldAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.QualByDepth;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AS_StandardAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.AlleleSpecificAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.ReducibleAnnotationData;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.read.GATKRead;

@DocumentedFeature(groupName="Variant Annotations", groupSummary="Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836", summary="Allele-specific call confidence normalized by depth of sample reads supporting the allele (AS_QD)")
public class AS_QualByDepth
extends InfoFieldAnnotation
implements ReducibleAnnotation,
AS_StandardAnnotation,
AlleleSpecificAnnotation {
    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("AS_QD");
    }

    @Override
    public String getPrimaryRawKey() {
        return "AS_QUALapprox";
    }

    @Override
    public boolean hasSecondaryRawKeys() {
        return true;
    }

    @Override
    public List<String> getSecondaryRawKeys() {
        return Arrays.asList("AS_QUAL");
    }

    @Override
    public List<VCFInfoHeaderLine> getRawDescriptions() {
        return this.getDescriptions();
    }

    @Override
    public Map<String, Object> annotate(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> annotateRawData(ReferenceContext ref, VariantContext vc, AlleleLikelihoods<GATKRead, Allele> likelihoods) {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> combineRawData(List<Allele> allelesList, List<ReducibleAnnotationData<?>> listOfRawData) {
        return null;
    }

    @Override
    public Map<String, Object> finalizeRawData(VariantContext vc, VariantContext originalVC) {
        if (!vc.hasAttribute("AS_QUAL") && !vc.hasAttribute("AS_QUALapprox")) {
            return null;
        }
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.isEmpty()) {
            return null;
        }
        List<Integer> standardDepth = originalVC.hasAttribute("AS_VarDP") ? Arrays.stream(originalVC.getAttributeAsString("AS_VarDP", "").split("\\|")).mapToInt(Integer::parseInt).boxed().collect(Collectors.toList()) : AS_QualByDepth.getAlleleDepths(genotypes);
        if (standardDepth == null) {
            return null;
        }
        List<Integer> alleleQualList = AS_QualByDepth.parseQualList(vc);
        ArrayList<Double> QDlist = new ArrayList<Double>();
        double refDepth = standardDepth.get(0).intValue();
        for (int i = 0; i < alleleQualList.size(); ++i) {
            double AS_QD = (double)alleleQualList.get(i).intValue() / ((double)standardDepth.get(i + 1).intValue() + refDepth);
            AS_QD = QualByDepth.fixTooHighQD(AS_QD);
            QDlist.add(AS_QD);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), AnnotationUtils.encodeValueList(QDlist, "%.2f"));
        if (vc.hasAttribute("AS_QUALapprox")) {
            map.put("AS_QUALapprox", StringUtils.join(alleleQualList, (String)","));
        }
        return map;
    }

    public static List<Integer> getAlleleDepths(GenotypesContext genotypes) {
        int numAlleles = -1;
        for (Genotype genotype : genotypes) {
            if (!genotype.hasAD()) continue;
            numAlleles = genotype.getAD().length;
            break;
        }
        if (numAlleles == -1) {
            return null;
        }
        Integer[] alleleDepths = new Integer[numAlleles];
        for (int i = 0; i < alleleDepths.length; ++i) {
            alleleDepths[i] = 0;
        }
        for (Genotype genotype : genotypes) {
            int[] AD;
            int totalADdepth;
            if (!genotype.isHet() && !genotype.isHomVar() || !genotype.hasAD() || (totalADdepth = (int)MathUtils.sum(AD = genotype.getAD())) - AD[0] <= 1) continue;
            for (int i = 0; i < AD.length; ++i) {
                Integer[] integerArray = alleleDepths;
                int n = i;
                Integer.valueOf(integerArray[n] + AD[i]);
            }
        }
        return Arrays.asList(alleleDepths);
    }

    public static String finalizeRawGVCFVarDPValues(String rawAnnotationListWithNonRef, int expectedFinalAlleleCount) {
        if (rawAnnotationListWithNonRef == null) {
            return null;
        }
        List<String> dpValues = Arrays.asList(rawAnnotationListWithNonRef.split("\\|"));
        if (dpValues.size() != expectedFinalAlleleCount + 1) {
            return null;
        }
        return String.join((CharSequence)",", dpValues.subList(1, dpValues.size() - 1));
    }

    public static List<Integer> parseQualList(VariantContext vc) {
        ArrayList<Integer> alleleQualList;
        block6: {
            block5: {
                alleleQualList = new ArrayList<Integer>();
                if (!vc.hasAttribute("AS_QUAL")) break block5;
                List alleleQualObjList = vc.getAttributeAsList("AS_QUAL");
                if (alleleQualObjList.size() != vc.getNAlleles() - 1) {
                    throw new IllegalStateException("Number of AS_QUAL values doesn't match the number of alternate alleles.");
                }
                for (Object obj : alleleQualObjList) {
                    alleleQualList.add(Integer.parseInt(obj.toString()));
                }
                break block6;
            }
            if (!vc.hasAttribute("AS_QUALapprox")) break block6;
            String asQuals = vc.getAttributeAsString("AS_QUALapprox", "").replaceAll("\\[\\]\\s", "");
            String[] values = asQuals.split("\\|", -1);
            if (values.length != vc.getNAlleles()) {
                throw new IllegalStateException("Number of AS_QUALapprox values doesn't match the number of alleles in the variant context.");
            }
            for (int i = 1; i < vc.getNAlleles(); ++i) {
                if (!values[i].equals("")) {
                    alleleQualList.add(Integer.parseInt(values[i]));
                    continue;
                }
                alleleQualList.add(0);
            }
        }
        return alleleQualList;
    }
}

